$(document).on('click', '#table_checklist .upload-btn', function() {
  $(this)
      .closest('.checklist-row')
      .find('.checklist-file-upload')
      .trigger('click');
});

$(document).on('change', '#table_checklist .checklist-checkbox', function() {
  var checkbox = $(this);
  var container = checkbox.closest('.checklist-row');
  var completed = checkbox.is(":checked") ? 1 : 0;
  var id = container.data('id');
  var url = app.urls.checklistUpdateRow;

  $.ajax({
      type: "POST",
      url: url+id,
      data: {
          completed: completed
      },
      beforeSend: function() {
          loader.add(container);
          $checklist.removerErrorRow(id, container);
      },
      success: function (response) {
          if (! response.status) {
              checkbox.prop('checked', false);
              $checklist.addErrorRow(id, container, response.error);
          }
      },
      error: function (response) {
      },
      complete: function() {
          loader.remove(container);
      }
  });

  $checklist.showSignatureField(container.closest('.group-collapse'));
});

$(document).on('change', '#table_checklist .checklist-file-upload', function() {
  var container = $(this).closest('.checklist-row');
  var id = container.data('id');
  var data = new FormData();
  var url = app.urls.checklistUploadFile;
  var file = $(this)[0].files[0];

  $checklist.removerErrorRow(id, container);

  if (! file) {
      $checklist.addErrorRow(id, container, "{{ trans('front.please_upload_image') }}");

      return;
  }

  data.append("file", file, file.name);

  $.ajax({
      type: "POST",
      url: url+container.data('id'),
      data: data,
      beforeSend: function() {
          loader.add(container);
      },
      success: function (response) {
      },
      error: function (response) {
      },
      complete: function() {
          loader.remove(container);
          $checklist.refreshRow(container);
      },
      async: true,
      cache: false,
      contentType: false,
      processData: false,
  });

  $checklist.enableFileDelete(container);
});

$(document).on('click', '#table_checklist .signature-wrapper .btn.sign', function() {
  var container = $(this).closest('.group');
  var checklistId = container.data('id');
  var url = app.urls.checklistSign + checklistId;
  var signature = container.find('.signature').val();
  var signatureWrapper = container.find('.signature-wrapper');

  if (container.find('input:checkbox:not(:checked)').length) {
      signatureWrapper.addClass('hidden');

      return ;
  }

  $.ajax({
      type: "POST",
      url: url,
      data: {
          signature: signature
      },
      beforeSend: function() {
          loader.add(container);
          container.find('.signature').removeClass('alert-success alert-danger');
      },
      success: function (response) {
          if (response.status) {
              container.find('.signature').addClass('alert-success');
              container.find('.group-heading .time_completed').text(response.completed_at);
          } else {
              container.find('.signature').addClass('alert-danger');
          }
      },
      error: function (response) {
      },
      complete: function() {
          loader.remove(container);
      }
  });
});

$(document).on('mouseover', '.thumbnail-preview', function() {
  var container = $(this);

  if (! container.hasClass('empty')) {
      return;
  }

  container.find('.full-preview img').attr('src', container.data('url'));
});

var $checklist = {
  enableFileDelete: function (container) {
    container.find('.icon.delete').removeClass('hidden');
  },

  refreshRow: function (container) {
    var url = app.urls.checklistGetRow + container.data('id');

    $.ajax({
        type: "GET",
        url: url,
        success: function (response) {
            container.html($($.parseHTML(response)[0]).html());
        },
    });
  },

  addErrorRow: function (id, container, error) {
    container.after('<tr class="danger text-center err-message-'+ id +'"><td colspan="3">'+error+'</td></tr>');
    container.addClass('danger');
  },

  removerErrorRow: function (id, container) {
    container.siblings('.err-message-'+ id).remove();
    container.removeClass('danger');
  },

  showSignatureFields: function () {
    var container = $('#table_checklist');

    container.find('.group-collapse').each(function() {
      $checklist.showSignatureField($(this));
    });
  },

  showSignatureField: function (container) {
    var signatureWrapper = container.find('.signature-wrapper');

    if (container.find('input:checkbox:not(:checked)').length) {
        signatureWrapper.addClass('hidden');
    } else {
        signatureWrapper.removeClass('hidden');
    }
  }
}