function Geofence(data) {
    var
        _this = this,
        defaults = {
            id: null,
            name: 'N/A',
            active: true,
            polygon_color: '#dddddd',
            coordinates: [],
            center: {},
            radius: null,
            type: 'polygon'
        },
        options = {},
        layer = null,
        popup = null;

    _this.id = function() {
        return options.id;
    };

    _this.options = function() {
        return options;
    };

    _this.active = function(value) {
        options.active = value;

        _this.update();
    };

    _this.isVisible = function() {
        return options.active == true;
    };

    _this.create = function(data) {
        $( document ).trigger('geofence.create', _this);

        data = data || {};

        options = $.extend({}, defaults, data);

        _this.searchValue = options.name.toLowerCase();

        $( document ).trigger('geofence.created', _this);
    };

    _this.update = function(data) {
        $( document ).trigger('geofence.update', _this);

        data = data || {};

        options = $.extend({}, options, data);

        _this.searchValue = options.name.toLowerCase();


        $( document ).trigger('geofence.updated', _this);
    };

    _this.getLatLngs = function() {
        if ( ! layer )
            return null;

        if (layer instanceof L.Polygon) {
            return layer.getLatLngs()[0];
        }
        else if (layer instanceof L.Circle) {
            return layer.getLatLng();
        }
    };

    _this.getLatLng = function() {
        if ( ! layer )
            return null;

        if (layer instanceof L.Polygon) {
            return layer.getLatLngs()[0][0];
        }
        else if (layer instanceof L.Circle) {
            return layer.getLatLng();
        }
    };


    _this.getBounds = function() {
        if ( ! layer )
            return [];

        return layer.getBounds();
    };

    _this.isLayerVisible = function () {
        if ( options.active != true ) {
            return false;
        }

        return app.settings.showGeofences == true;
    };

    _this.setLayer = function (_layer) {
        _this.removeLayer();

        layer = _layer;

        layer
            .on('remove', _this.onLayerRemove)
            .on('add', _this.onLayerAdd);

        return layer;
    };

    _this.getLayer = function (_options) {
        _options = $.extend({}, options, _options);

        if (layer)
            return layer;

        try {
            switch (_options.type) {
                case 'polygon':
                    layer = L.polygon(_options.coordinates, {
                        color: _options.polygon_color,
                        weight: 3,
                        opacity: 1,
                        fill: true,
                        fillOpacity: 0.3,
                        fillColor: _options.polygon_color
                    });
                    break;
                case 'circle':
                    layer = L.circle(_options.center, {
                        radius: _options.radius,
                        color: _options.polygon_color,
                        weight: 3,
                        opacity: 1,
                        fill: true,
                        fillOpacity: 0.3,
                        fillColor: _options.polygon_color
                    });
                    break;

                default:
                    layer = L.polygon(_options.coordinates, {
                        color: _options.polygon_color,
                        weight: 3,
                        opacity: 1,
                        fill: true,
                        fillOpacity: 0.3,
                        fillColor: _options.polygon_color
                    });
            }

            layer
                .on('remove', _this.onLayerRemove)
                .on('add', _this.onLayerAdd);

        } catch (err) {
            console.log(err.message);
        }

        return layer;
    };

    _this.updateLayer = function() {
        if ( ! _this.isLayerVisible() ) {
            _this.removeLayer();
        }
    };

    _this.removeLayer = function() {
        if ( ! layer )
            return;

        app.map.removeLayer( layer );

        layer = null;
    };

    _this.enableEdit = function(_options) {
        _this.getLayer(_options).editing.enable();
    };

    _this.disableEdit = function() {
        _this.getLayer().editing.disable();
    };

    _this.addPopup = function() {
        if ( ! layer )
            return;

        if ( ! app.settings.showGeofences )
            return;

        popup = new L.Marker(
            null,
            {
                icon: L.divIcon({
                    html: '<div class="name" style="background-color: ' + convertHex(options.polygon_color, 81) + '">' + options.name + '</div>',
                    className: 'leaflet-popup-geofence',
                    iconSize: 'auto'
                    //iconAnchor: [(width / 2), (height / 2)],
                    //popupAnchor: [0, 0 - height]
                })
            }
        );

        var _latLng = _this.getLatLng();

        if ( ! _latLng)
            return;

        popup.setLatLng(_latLng).addTo(app.map);

/*
        if (layer instanceof L.Polygon) {
            if (!layer.isEmpty()) {
                popup.setLatLng(layer.getCenter()).addTo(app.map);
            }
        } else if (layer instanceof L.Circle) {
            popup.setLatLng(layer.getLatLng()).addTo(app.map);
        }
*/
    };

    _this.removePopup = function() {
        if ( popup )
            popup.remove();
    };

    _this.onLayerAdd = function() {
        dd('goefence.onLayerAdd');
        _this.addPopup();
    };

    _this.onLayerRemove = function() {
        dd('goefence.onLayerRemove');
        _this.removePopup();
    };

    _this.create(data);

    _this.polygonToCircle = function() {
        if ( ! options.coordinates)
            return;

        if ( ! options.coordinates.length > 0)
            return;

        var _layer = L.polygon(options.coordinates);

        app.map.addLayer( _layer );

        if ( ! _layer.getBounds().isValid())
            return;

        var
            center = _layer.getBounds().getCenter(),
            radius = _layer.getBounds().getSouthWest().distanceTo(_layer.getBounds().getNorthEast()) / 2;

        app.map.removeLayer( _layer );
        _layer = null;

        return {
            center: center,
            radius: radius
        }
    };

    _this.circleToPolygon = function() {
        if ( ! options.center)
            return;

        if ( ! options.radius)
            return;

        var _layer = L.circle(options.center, {radius: options.radius});

        app.map.addLayer( _layer );

        var
            coordinates = _layer.toPolygon();

        app.map.removeLayer( _layer );
        _layer = null;

        return {
            coordinates: coordinates
        }
    };
}