<?php

// Composer: "fzaninotto/faker": "v1.3.0"
use Faker\Factory as Faker;
use Tobuli\Repositories\User\UserRepositoryInterface as User;
use Illuminate\Database\Seeder;
use Tobuli\Services\PermissionService;

class UsersTableSeeder extends Seeder {

    /**
     * @var User
     */
    private $user;

    function __construct(User $user)
    {
        // TODO: Implement __construct() method.
        $this->user = $user;
    }

	public function run()
	{
		$users = [];

        $user = $this->user->create([
            'email' => 'admin@gpswox.com',
            'password' => 'raktelis9821',
            'group_id' => 1,
            'map_id' => config('tobuli.main_settings.default_map'),
            'available_maps' => config('tobuli.main_settings.available_maps'),
            'open_device_groups' => '["0"]',
            'open_geofence_groups' => '["0"]'
        ]);
        
        $users[$user->id] = $user->id;

        $user = $this->user->create([
            'email' => 'admin@yourdomain.com',
            'password' => 'pass6342word',
            'group_id' => 1,
            'map_id' => config('tobuli.main_settings.default_map'),
            'available_maps' => config('tobuli.main_settings.available_maps'),
            'open_device_groups' => '["0"]',
            'open_geofence_groups' => '["0"]'
        ]);

        $users[$user->id] = $user->id;

        $permissions = (new PermissionService())->getByGroupId(PermissionService::GROUP_ADMIN);
        
        foreach ($users as $key => $user) {
            $user_permissions = [];

            foreach ($permissions as $name => $modes)
            {
                $user_permissions[] = array_merge([
                    'user_id' => $user,
                    'name' => $name,
                ], $modes);
            }

            DB::table('user_permissions')->insert($user_permissions);
        }

	}
}