<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Tobuli\Helpers\Language;

class LanguageServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton('Tobuli\Helpers\Language', function ($app) {
            return new Language( 'en' );
        });
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['Tobuli\Helpers\Language'];
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        \Facades\Language::set( settings('main_settings.default_language') );
    }
}
