<?php namespace App\Providers;

use App\Listeners\NewMessageListener;
use Illuminate\Contracts\Events\Dispatcher as DispatcherContract;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider {

    /**
     * The event handler mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        'auth.login' => [
            'App\Handlers\Events\AuthLoginEventHandler',
            'App\Listeners\SetActingUser',
        ],
        'auth.logout' => [
            'App\Handlers\Events\AuthLogoutEventHandler',
        ],
        'event.name' => [
            'EventListener',
        ],
        'App\Events\NewMessage' => [
            'App\Listeners\NewMessageListener'
        ],
        'App\Events\TranslationUpdated' => [
            'App\Listeners\TranslationUpdatedListener',
        ],
    ];

	/**
	 * Register any other events for your application.
	 *
	 * @param  \Illuminate\Contracts\Events\Dispatcher  $events
	 * @return void
	 */
	public function boot(DispatcherContract $events)
	{
		parent::boot($events);

        //
    }

}
