<?php namespace App\Providers;

use Illuminate\Database\Query\Builder;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider {

	/**
	 * Bootstrap any application services.
	 *
	 * @return void
	 */
	public function boot()
	{
		//
	}

	/**
	 * Register any application services.
	 *
	 * @return void
	 */
	public function register()
	{
        Builder::macro("clearOrdersBy", function () {
            $this->{$this->unions ? 'unionOrders' : 'orders'} = null;

            return $this;
        });

        Builder::macro("isJoined", function ($table) {
            if($this->joins == null) {
                return false;
            }

            foreach ($this->joins as $join) {
                if ($join->table == $table) {
                    return true;
                }
            }

            return false;
        });
	}

}
