<?php

namespace App\PropertyPolicies;


use Illuminate\Database\Eloquent\Model;
use Tobuli\Entities\User;

class DevicePropertiesPolicy extends PropertyPolicy
{
    protected $entity = 'device';

    protected $editable = [
        'protocol',
        'imei',
        'forward',
        'sim_number',
        'expiration_date',
        'sim_activation_date',
        'sim_expiration_date',
        'installation_date',
    ];

    protected $viewable = [
        'protocol',
        'imei',
        'forward',
        'sim_number',
        'expiration_date',
        'sim_activation_date',
        'sim_expiration_date',
        'installation_date',
    ];

    protected function expirationDateEditPolicy(User $user, Model $model)
    {
        if ( ! ($user->isManager() || $user->isAdmin()))
            return false;

        return true;
    }
}