<?php

//require base_path().'/filters.php';
require base_path().'/Tobuli/Helpers/SendSmsHelper.php';
require base_path().'/Tobuli/Helpers/Helper.php';
require base_path().'/Tobuli/Helpers/NavigationHelper.php';
require base_path().'/Tobuli/Helpers/FormHelper.php';
require base_path().'/Tobuli/Helpers/TableHelper.php';
require base_path().'/Tobuli/Helpers/SensorsHelper.php';
require base_path().'/Tobuli/Helpers/UTF8.php';
require base_path().'/Tobuli/Helpers/SettingsHelper.php';

View::addLocation(base_path().'/Tobuli/Views');
View::addNamespace('admin', base_path().'/Tobuli/Views/Admin');
View::addNamespace('front', base_path().'/Tobuli/Views/Frontend');

class CustomRules extends \Illuminate\Validation\Validator {

    public function validatePhone($attribute, $value, $parameters)
    {
        return preg_match("/^\+\d[0-9]{10}/", $value);
    }

    public function validateArrayMax($attribute, $value, $parameters)
    {
        return count($value) <= $parameters['0'];
    }

    protected function replaceArrayMax($message, $attribute, $rule, $parameters)
    {
        return str_replace(':max', $parameters[0], $message);
    }

    protected function validateLesserThan($attribute, $value, $parameters) {
        $param = array_get($this->data, $parameters[0]);
        return $value < $param;
    }

    protected function replacelesserThan($message, $attribute, $rule, $parameters)
    {
        return str_replace(':other', trans('validation.attributes.'.$parameters[0]), $message);
    }

}

Validator::resolver(function($translator, $data, $rules, $messages)
{
    return new CustomRules($translator, $data, $rules, $messages);
});


