<?php namespace App\Http\Middleware;

use Closure;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class Authenticate {

	/**
	 * The Guard implementation.
	 *
	 * @var Guard
	 */
	protected $auth;

	/**
	 * Create a new filter instance.
	 *
	 * @param  Guard  $auth
	 * @return void
	 */
	public function __construct(Guard $auth)
	{
		$this->auth = $auth;
	}

	/**
	 * Handle an incoming request.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  \Closure  $next
	 * @return mixed
	 */
	public function handle($request, Closure $next)
	{
		if ($this->auth->guest())
		{
            return $this->redirect($request);
		}

		if ( ! Auth::User()->active)
		{
            return $this->redirect($request);
		}

		if ($request->session()->has('hash')) {
            if ($request->session()->get('hash') !== Auth::User()->password_hash)
            {
                Auth::logout();

                return $this->redirect($request);
            }
        } else {
            $request->session()->set('hash', Auth::User()->password_hash);
        }

		Auth::User()->loged_at = date('Y-m-d H:i:s');
		Auth::User()->save();

        setActingUser(Auth::User());

		return $next($request);
	}

	private function redirect($request)
    {
        if ( ! $this->auth->guest())
            $this->auth->logout();

        if ($request->ajax())
            return response('Unauthorized.', 401);

        if (isPublic()) {
            return redirect()->guest(config('tobuli.frontend_login').'/?server='.$_ENV['server']);
        }

        return redirect()->guest(route('home'));
    }
}
