<?php namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use DateTime;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;


class SubscriptionsController extends Controller
{
    public function index()
    {
        $time = new DateTime(date('Y-m-d H:i:s'));

        $days_left = $time->diff(new DateTime(Auth::User()->subscription_expiration))->days;

        return View::make('front::Subscriptions.index')->with(compact('item', 'days_left'));
    }

    public function languages()
    {
        $languages = array_sort(settings('languages'), function ($language) {
            return $language['title'];
        });

        $languages = array_filter($languages, function ($language) {
            return $language['active'];
        });

        return View::make('front::Subscriptions.languages', compact('languages'));
    }
}