<?php namespace App\Http\Controllers\Frontend;

use Curl;
use App\Http\Controllers\Controller;
use Facades\ModalHelpers\RegistrationModalHelper;
use Tobuli\Exceptions\ValidationException;

class RegistrationController extends Controller
{
    public function create()
    {
        return view('front::Registration.create');
    }
    
    public function store()
    {
        try {
            $data = RegistrationModalHelper::create();
        } catch (ValidationException $e) {
            $data = [
                'status' => 0,
                'errors' => $e->getErrors()
            ];
        }

        if ($this->api)
            return $data;

        if ($data['status'])
            return redirect()->route('login')->with('success', trans('front.registration_successful'));

        return redirect()->route('registration.create')->withInput()->withErrors($data['errors']);
    }
}