<?php namespace App\Http\Controllers\Frontend;

use Formatter;
use App\Exceptions\PermissionException;
use App\Http\Controllers\Controller;

use Facades\ModalHelpers\DeviceModalHelper;
use Facades\Repositories\DeviceGroupRepo;
use Facades\Repositories\DeviceRepo;
use Facades\Repositories\GeofenceGroupRepo;
use Facades\Repositories\MapIconRepo;
use Facades\Repositories\UserDriverRepo;

use Facades\Repositories\UserRepo;
use Facades\Repositories\TimezoneRepo;
use Facades\Validators\ObjectsListSettingsFormValidator;
use Tobuli\Exceptions\ValidationException;
use Tobuli\Lookups\Tables\ObjectListLookupTable;


class ObjectsListLookupController extends Controller {

    /*
     * @var Tobuli\Lookups\LookupTable
     */
    protected $lookup;

    public function __construct(ObjectListLookupTable $lookup)
    {
        parent::__construct();

        $this->lookup = $lookup;
        $this->lookup->setUser($this->user);

        if ( ! $this->lookup->checkPermission())
           throw new PermissionException();
    }

    public function index()
    {
        $data = [
            'html'     => $this->lookup->html(),
            'lookup'   => $this->lookup,
        ];

        if (request()->ajax())
            return view('front::Lookup.modal', $data);
        else
            return view('front::Lookup.index', $data);
    }

    public function data()
    {
        return $this->lookup->render($this->lookup->getPrintView());
    }

    public function edit()
    {
        $this->checkException('users', 'edit', $this->user);

        $numeric_sensors = config('tobuli.numeric_sensors');

        $settings = UserRepo::getListViewSettings($this->user->id);

        $fields = config('tobuli.listview_fields');

        listviewTrans($this->user->id, $settings, $fields);

        return view('front::ObjectsList.edit')->with(compact('fields','settings','numeric_sensors'));
    }

    public function update()
    {
        $this->checkException('users', 'update', $this->user);

        try
        {
            ObjectsListSettingsFormValidator::validate('update', $this->data);

            UserRepo::setListViewSettings($this->user->id, request()->only(['columns','groupby']));

            return ['status' => 1];
        }
        catch (ValidationException $e)
        {
            return ['status' => 0, 'errors' => $e->getErrors()];
        }
    }
}
