<?php namespace App\Http\Controllers\Frontend;

use App\Exceptions\ResourseNotFoundException;
use App\Http\Controllers\Controller;
use Facades\ModalHelpers\MapIconModalHelper;
use Illuminate\Support\Facades\Response;
use Tobuli\Exceptions\ValidationException;
use Tobuli\Importers\POI\POIImportManager;

class MapIconsController extends Controller
{
    public function index()
    {
        $data = MapIconModalHelper::get();

        return !$this->api ? view('front::MapIcons.index')->with($data) : ['items' => $data];
    }

    public function getIcons()
    {
        $data = MapIconModalHelper::getIcons();

        if ($this->api && !$this->user->perm('poi', 'edit'))
            return ['status' => 0, 'perm' => 0];

        return !$this->api ? view('front::MapIcons.index')->with($data) : ['items' => $data];
    }


    public function store()
    {
        return MapIconModalHelper::create();
    }

    public function update()
    {
        return MapIconModalHelper::edit();
    }

    public function changeActive()
    {
        return MapIconModalHelper::changeActive();
    }

    public function iconsList()
    {
        return MapIconModalHelper::iconsList();
    }

    public function destroy()
    {
        return MapIconModalHelper::destroy();
    }

    public function import_form()
    {
        $icons = MapIconModalHelper::getIcons();

        return view('front::MapIcons.import')->with(compact('icons'));
    }

    public function import(POIImportManager $importManager)
    {
        $this->checkException('poi', 'store');

        $file = request()->file('file');

        if (is_null($file))
            throw new ResourseNotFoundException(trans('validation.attributes.file'));

        try {
            if ( ! $file->isValid())
                throw new \Exception(trans('front.unsupported_format'));

            $additionals = request()->only(['map_icon_id']);
            $importManager->import($file, $additionals);
        } catch (ValidationException $e) {
            return Response::json(['status' => 0, 'errors' => $e->getErrors()]);
        }

        return Response::json(['status' => 1]);
    }
}
