<?php namespace App\Console\Commands;
ini_set('memory_limit', '-1');
set_time_limit(0);

use Curl;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputArgument;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Tobuli\Services\TranslationService;

class UpdateServerCommand extends Command {
    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'server:update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Updates server database and configuration to the newest version.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function fire()
    {
        try {
            $translationService = new TranslationService();
            $translationService->updateTranslationFiles();

            $this->line('Ok');
        }
        catch (\Exception $e) {
        }

    }

    /**
     * Get the console command arguments.
     *
     * @return array
     */
    protected function getArguments()
    {
        return array();
    }

    /**
     * Get the console command options.
     *
     * @return array
     */
    protected function getOptions()
    {
        return array();
    }
}
