<?php namespace App\Console\Commands;
ini_set('memory_limit', '-1');
set_time_limit(0);
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Tobuli\Entities\Event;
use Tobuli\Entities\Alert;
use Tobuli\Entities\SendQueue;
use Tobuli\Helpers\Alerts\Checker;

class CheckStopDurationAlertsCommand extends Command
{
    private $events = [];

    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'alerts:checkStopDuration';
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check for stop duration alerts and add them';
    /**
     * Create a new command instance.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function fire()
    {
        $alerts = Alert::with('user', 'devices', 'devices.traccar')
            ->checkByTime()
            ->active()
            ->get();

        foreach ($alerts as $alert) {
            foreach ($alert->devices as $device)
            {
                $checker = new Checker($device, [$alert]);

                $events = $checker->check();

                if ( ! $events)
                    continue;

                $this->events = array_merge($this->events, $events);
            }
        }

        $this->writeEvents();

        echo "DONE\n";
    }

    protected function writeEvents()
    {
        if ( ! $this->events)
            return;

        $events = [];
        $queues = [];

        foreach ($this->events as $event)
        {
            $events[] = $event->toArrayMassInsert();
            $queues[] = (new SendQueue([
                'user_id'   => $event->user_id,
                'type'      => $event->type,
                'data'      => $event,
                'channels'  => $event->channels
            ]))->toArrayMassInsert();
        }

        $this->events = [];

        Event::insert($events);
        SendQueue::insert($queues);
    }
    /**
     * Get the console command arguments.
     *
     * @return array
     */
    protected function getArguments()
    {
        return array();
    }
    /**
     * Get the console command options.
     *
     * @return array
     */
    protected function getOptions()
    {
        return array();
    }
}