@extends('Frontend.Layouts.default')

@section('header-menu-items')
    @if ( Auth::User() )
        <li>
            <a href="{{ route('logout') }}">
                <i class="icon logout"></i> <span class="text">{{ trans('global.log_out') }}</span>
            </a>
        </li>
    @endif
@stop

@section('content')
    <div class="row">
        <div class="col-lg-offset-2 col-lg-8">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="panel-title">{!! trans('Adyen') !!}</div>
                </div>

                <div class="panel-body">
                    <div class="col-lg-offset-2 col-lg-8">
                        <div class="form-group">
                            <label>{{ trans('select_method') }}</label>
                            <select id="method-select" class="form-control">
                                @foreach($payment_methods as $method)
                                    <option value="{{ $method['type'] }}">{{ $method['name'] }}</option>
                                @endforeach
                            </select>
                        </div>

                        @foreach($payment_methods as $method)
                            {!! Form::open([
                                'route'     => ['payments.subscribe', 'plan_id' => $plan_id, 'gateway' => $gateway],
                                'method'    => 'POST',
                                'id'        => $method['type'],
                                'hidden'    => 'hidden'
                            ]) !!}

                            <div class="cards-div">
                                <div class="js-chckt-pm__pm-holder">
                                    <input type="hidden" name="txvariant" value="card"/>
                                    {!! Form::hidden('type', $method['type']) !!}

                                    @if(array_get($method, 'details'))
                                        @foreach($method['details'] as $detail)
                                            @if($detail['type'] === 'text')
                                                <div class="form-group">
                                                    {!! Form::label(trans($detail['key']), ucfirst($detail['key'])) !!}
                                                    {!! Form::text($detail['key'], null, ['class' => 'form-control']) !!}
                                                </div>
                                            @elseif($detail['type'] === 'cardToken')
                                                <div class="form-group">
                                                    <label>{{ trans($detail['key']) }}</label>
                                                    <span class="input-field form-control"
                                                          data-cse="{{ $detail['key'] }}"></span>
                                                </div>
                                            @elseif($detail['type'] === 'select')
                                                <div class="form-group">
                                                    <label for="{{ $detail['key'] }}">{{ $detail['key'] }}</label>
                                                    <select name="{{ $detail['key'] }}" class="form-control">
                                                        @foreach($detail['items'] as $item)
                                                            <option value="{{ $item['id'] }}">{{ $item['name'] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            @endif
                                        @endforeach
                                    @endif

                                    <button type="submit" class="btn btn-primary form-control"
                                            id="submit_button">
                                        Proceed
                                    </button>

                                    {!! Form::close() !!}
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop

@section('scripts')
    <script type="text/javascript" src="{{ asset('assets/plugins/payments/adyen.js') }}"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            var method_select = $('#method-select');
            var method = method_select.val();
            $('#' + method).show();
            method_select.on('change', function (e) {
                $('#' + method).hide();
                var current_method = e.target.value;
                $('#' + current_method).show();
                method = current_method;
            });

            var securedFields = csf({
                rootNode: '.cards-div',
                configObject: {
                    originKey: '{{ $origin_key }}'
                },
                paymentMethods: {
                    card: {
                        sfStyles: {
                            base: {
                                color: 'black',
                                fontSize: '14px',
                                fontSmoothing: 'antialiased',
                                fontFamily: 'Helvetica'
                            },
                            error: {
                                color: 'red'
                            },
                            placeholder: {
                                color: '#d8d8d8'
                            },
                            validated: {
                                color: 'green'
                            }
                        }
                    }
                }
            });
        });
    </script>
@stop