@extends('Frontend.Reports.partials.layout')

@section('content')
    @foreach ($report->getItems() as $item)
    <div class="panel panel-default">
        @include('Frontend.Reports.partials.item_heading')

        @if (! empty($item['data']))
            @foreach ($item['data'] as $data)
            <div class="panel-body no-padding">
                <table class="table table-striped table-speed">
                    <thead>
                        <tr>
                            <th colspan="3">{{ trans('front.service').': '.$data['service']->name }}</th>
                        </tr>
                        <tr>
                            <th>{{ trans('validation.attributes.status') }}</th>
                            <th>{{ trans('front.activity') }}</th>
                            <th>{{ trans('front.time_completed') }}</th>
                        </tr>
                    </thead>

                    @foreach ($data['checklists'] as $checklist)
                    <tbody>
                        <tr>
                            <td colspan="3" style="text-align: left;">
                                <div class="panel-body">
                                    <div>{{ trans('front.checklist').': '.$checklist->name }}</div>
                                    <div>{{ trans('front.time_completed').': '.($checklist->completed_at ? Formatter::time()->human($checklist->completed_at) : trans('front.incomplete')) }}</div>
                                    <div>{{ trans('validation.attributes.signature').': '.$checklist->signature }}</div>
                                </div>
                            </td>
                        </tr>
                        @foreach ($checklist->rows as $row)
                            <tr>
                                <td>{{ $row['completed'] ? trans('front.complete') : trans('front.incomplete') }}</td>
                                <td>{{ $row['activity'] }}</td>
                                <td>{{ $row['completed_at'] ? Formatter::time()->human($row['completed_at']) : '-' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    @endforeach
                </table>
            </div>
            @endforeach
        @endif
    </div>
    @endforeach
@stop
