@extends('Frontend.Reports.partials.layout')

@section('content')
    @foreach ($report->getItems() as $item)
    <div class="panel panel-default">
        @include('Frontend.Reports.partials.item_heading')

        @if ( ! empty($item['table']))
            <div class="panel-body no-padding">
                <table class="table table-striped table-speed">
                    <thead>
                    <tr>
                        <th>{{ rtl(trans('validation.attributes.date'), $data) }}</th>
                        <th>{{ rtl(trans('front.travel_start_time'), $data) }}</th>
                        <th>{{ rtl(trans('front.travel_end_time'), $data) }}</th>
                        <th>{{ rtl(trans('front.travel_time'), $data) }}</th>
                        <th>{{ rtl(trans('front.distance_travelled'), $data) }}</th>
                        <th>{{ rtl(trans('front.move_duration'), $data) }}</th>
                    </tr>
                    </thead>

                    <tbody>
                    @foreach ($item['table']['rows'] as $row)
                        <tr>
                            <td>{{ $row['date'] }}</td>
                            <td>{{ $row['first_drive'] }}</td>
                            <td>{{ $row['last_drive'] }}</td>
                            <td>{{ $row['duration'] }}</td>
                            <td>{{ $row['distance'] }}</td>
                            <td>{{ $row['drive_duration'] }}</td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    </div>
    @endforeach
@stop