@extends('Frontend.Reports.partials.layout')

@section('content')
    @foreach ($report->getItems() as $item)
        <div class="panel panel-default">
            @include('Frontend.Reports.partials.item_heading')

            <div class="panel-body no-padding">
                <table class="table table-striped table-speed">
                    <thead>
                    <tr>
                        <th>{{ rtl(trans('validation.attributes.date'), $data) }}</th>
                        <th>{{ rtl(trans('validation.attributes.name'), $data) }}</th>
                        <th>{{ rtl(trans('validation.attributes.type'), $data) }}</th>
                        <th>{{ rtl(trans('global.quantity'), $data) }}</th>
                        <th>{{ rtl(trans('validation.attributes.unit_cost'), $data) }}</th>
                        <th>{{ rtl(trans('front.total'), $data) }}</th>
                        <th>{{ rtl(trans('validation.attributes.supplier'), $data) }}</th>
                        <th>{{ rtl(trans('validation.attributes.buyer'), $data) }}</th>
                        <th>{{ rtl(trans('validation.attributes.additional_notes'), $data) }}</th>
                    </tr>
                    </thead>
                    <tbody>

                    @if (empty($item['data']['expenses']))
                        <tr>
                            <td colspan="20">{{ rtl(trans('front.nothing_found_request'), $data) }}</td>
                        </tr>
                    @else
                        @foreach($item['data']['expenses'] as $expense)
                            <tr>
                                <td>{{ $expense['date'] }}</td>
                                <td>{{ $expense['name'] }}</td>
                                <td>{{ $expense['type']['name'] ?? null }}</td>
                                <td>{{ $expense['quantity'] }}</td>
                                <td>{{ $expense['unit_cost'] }}</td>
                                <td>{{ $expense['total'] }}</td>
                                <td>{{ $expense['supplier'] }}</td>
                                <td>{{ $expense['buyer'] }}</td>
                                <td>{{ $expense['additional'] }}</td>
                            </tr>
                        @endforeach
                    @endif

                    </tbody>
                    <tfoot>
                    <tr>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th>{{ $item['data']['sum'] }}</th>
                        <th></th>
                        <th></th>
                        <th></th>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    @endforeach

@stop