@extends('Frontend.Reports.partials.layout')

@section('content')
    @foreach ($report->getItems() as $item)
        <div class="panel panel-default">
            @include('Frontend.Reports.partials.item_heading')

            @if (isset($item['error']))
                @include('Frontend.Reports.partials.item_empty')
            @else
                @if ( ! empty($item['table']['rows']))
                    <div class="panel-body no-padding">
                        <table class="table table-striped table-speed">
                            <thead>
                            <tr>
                                <th>{{ rtl(trans('front.position_a'), $data) }}</th>
                                <th>{{ rtl(trans('front.leave'), $data) }}</th>
                                <th>{{ rtl(trans('front.duration'), $data) }}</th>
                                <th>{{ rtl(trans('front.route_length'), $data) }}</th>
                                <th>{{ rtl(trans('front.position_b'), $data) }}</th>
                                <th>{{ rtl(trans('front.end'), $data) }}</th>
                                <th>{{ rtl(trans('front.time_at_location'), $data) }}</th>
                                <th>{{ rtl(trans('front.departure_time'), $data) }}</th>
                                <th>{{ rtl(trans('front.average_speed'), $data) }}</th>
                                <th>{{ rtl(trans('front.top_speed'), $data) }}</th>
                            </tr>
                            </thead>

                            <tbody>
                            @foreach(array_chunk($item['table']['rows'], 2) as $chunk)
                                <tr>
                                    <td>{!! $chunk[0]['location_start'] !!}</td>
                                    <td>{{ $chunk[0]['start_at'] }}</td>
                                    <td>{{ $chunk[0]['duration'] }}</td>
                                    <td>{{ $chunk[0]['distance'] }}</td>
                                    <td>{!! $chunk[0]['location_end'] !!}</td>
                                    <td>{{ $chunk[0]['end_at'] }}</td>
                                    <td>{{ array_get($chunk, '1.duration') }}</td>
                                    <td>{{ array_get($chunk, '1.end_at') }}</td>
                                    <td>{{ $chunk[0]['speed_avg'] }}</td>
                                    <td>{{ $chunk[0]['speed_max'] }}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif

                @include('Frontend.Reports.partials.item_total')
            @endif
        </div>
    @endforeach
@stop