@extends('Frontend.Reports.partials.layout')

@section('content')
    @foreach ($report->getItems() as $item)
        @if ( ! empty($item['data']['commands']))
        <div class="panel panel-default">
            @include('Frontend.Reports.partials.item_heading')

            <div class="panel-body no-padding">
                <table class="table table-striped table-speed" style="margin-bottom: 0px">
                    <thead>
                    <tr>
                        <th>{{ rtl(trans('front.time'), $data) }}</th>
                        @if($report->globalTotals('is_manager'))
                            <th>{{ rtl(trans('global.user'), $data) }}</th>
                        @endif
                        <th>{{ rtl(trans('front.connection'), $data) }}</th>
                        <th>{{ rtl(trans('front.command'), $data) }}</th>
                        <th>{{ rtl(trans('validation.attributes.status'), $data) }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @if (empty($item['data']['commands']))
                        <tr>
                            <td colspan="5">{{ rtl(trans('front.nothing_found_request'), $data) }}</td>
                        </tr>
                    @else
                        @foreach ($item['data']['commands'] as $item)
                            <tr>
                                <td>{{ $item['time'] }}</td>
                                @if($report->globalTotals('is_manager'))
                                    <td>{{ $item['email'] }}</td>
                                @endif
                                <td>{{ $item['connection'] }}</td>
                                <td>{{ $item['command'] }}</td>
                                <td>{{ $item['status'] }}</td>
                            </tr>
                        @endforeach
                    @endif
                    </tbody>
                </table>
            </div>
        </div>
        @endif
    @endforeach
@stop