@extends('Frontend.Reports.partials.layout')

@section('content')
    <div class="panel panel-default">
        @include('Frontend.Reports.partials.item_heading')

        <div class="panel-body no-padding">
            <table class="table table-striped table-speed">
                <thead>
                <tr>
                    @foreach($report->metas('device') as $meta)
                        <th>{{ $meta['title'] }}</th>
                    @endforeach
                    <th>{{ rtl(trans('front.route_start'), $data) }}</th>
                    <th>{{ rtl(trans('front.route_end'), $data) }}</th>
                    <th>{{ rtl(trans('front.route_length'), $data) }}</th>
                    <th>{{ rtl(trans('front.move_duration'), $data) }}</th>
                    <th>{{ rtl(trans('front.stop_duration'), $data) }}</th>
                    <th>{{ rtl(trans('front.top_speed'), $data) }}</th>
                    <th>{{ rtl(trans('front.average_speed'), $data) }}</th>
                    <th>{{ rtl(trans('front.overspeed_count'), $data) }}</th>
                    <th>{{ rtl(trans('front.fuel_consumption'), $data) }}</th>
                    <th>{{ rtl(trans('front.fuel_cost'), $data) }}</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($report->getItems() as $item)
                    <tr>
                    @foreach($item['meta'] as $key => $meta)
                        <td>{{ $meta['value'] }}</td>
                    @endforeach
                    @if (isset($item['error']))
                            <td colspan="20">{{ $item['error'] }}</td>
                    @else
                        <td>{{ $item['totals']['start_at'] }}</td>
                        <td>{{ $item['totals']['end_at'] }}</td>
                        <td>{{ $item['totals']['distance'] }}</td>
                        <td>{{ $item['totals']['drive_duration'] }}</td>
                        <td>{{ $item['totals']['stop_duration'] }}</td>
                        <td>{{ $item['totals']['speed_max'] }}</td>
                        <td>{{ $item['totals']['speed_avg'] }}</td>
                        <td>{{ $item['totals']['overspeed_count'] }}</td>
                        <td>{{ $item['totals']['fuel_consumption'] }}</td>
                        <td>{{ $item['totals']['fuel_price'] }}</td>
                    @endif
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@stop