@extends('Frontend.Reports.parse.layout')

@section('scripts')
    <script src="{{ asset('assets/js/report.js') }}" type="text/javascript"></script>
@stop

@section('styles')
    <link rel="stylesheet" href="{{ asset('assets/css/report-map.css?v='.config('tobuli.version')) }}">
@stop

@section('content')
    @foreach ($devices as $device)
        <div class="panel panel-default">
            <div class="panel-heading">
                {{ rtl(trans('front.report_type'), $data) }}: {{ rtl($types[$data['type']], $data) }}
            </div>
            <div class="panel-body">
                <table class="table" style="margin-bottom: 0px">
                    <tbody>
                    <tr>
                        <th>{!! rtl(trans('front.time_period'), $data) !!}:</th>
                        <td>{{ $data['date_from'] }} - {{ $data['date_to'] }}</td>
                        <th>&nbsp;</th>
                        <td>&nbsp;</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="panel-body">
                @if ( ! isset($items[$device['id']]))
                    <p>
                        {{ rtl($device['name'], $data) }} {{ rtl(trans('front.nothing_found_request'), $data) }}
                    </p>
                @else
                    <div class="row">
                        <div class="col-md-6">
                            <div style="overflow: hidden; position: relative; width: 100%;height: 300px;">
                                <script>
                                    var app = {
                                        settings: {
                                            showTraffic: false
                                        }
                                    };
                                </script>
                                <div id="map-{{ $device['imei'] }}"
                                     style="overflow: hidden;position: absolute;top: 0;bottom: 0;left: 0;right: 0;"></div>
                                <script src="https://maps.google.com/maps/api/js?key=AIzaSyCLwskBgrElxn4IqqnCLOOKrPcUPSvHTHw"
                                        type="text/javascript" async defer></script>
                                <script>
                                    var map = L.map("map-{{ $device['imei'] }}", {
                                        zoomControl: false,
                                        attributionControl: false,
                                        boxZoom: false,
                                    });

                                    new L.TileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {maxZoom: 18}).addTo(map);

                                    var latlngs = {{ $items[$device['id']]->polyline }};

                                    L.marker(latlngs[0]).addTo(map);
                                    L.marker(latlngs[latlngs.length - 1]).addTo(map);

                                    var polyline = L.polyline(latlngs, {color: 'blue'}).addTo(map);

                                    map.fitBounds(polyline.getBounds());
                                </script>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <table class="table">
                                <tbody>
                                <tr>
                                    <td><strong>{!! rtl(trans('global.device'), $data) !!}:</strong></td>
                                    <td>{{ $device['name'] }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ rtl(trans('front.route_start'), $data) }}:</strong></td>
                                    <td>{{ $items[$device['id']]->route_start }}</td>
                                    <td><strong>{{ rtl(trans('front.fuel_consumption'), $data) }}:</strong></td>
                                    @if (empty($items[$device['id']]->fuel_consumption))
                                        <td>{{ $device['fuel_measurement_id'] == 1 ? float($items[$device['id']]->distance_sum * $device['fuel_per_km']).' '.trans('front.liters') : float(litersToGallons($items[$device['id']]->distance_sum * $device['fuel_per_km'])).' '.trans('front.gallons') }}</td>
                                    @else
                                        <?php
                                        $cons = 0;
                                        foreach ($items[$device['id']]->fuel_consumption as $id => $value) {
                                            $cons += $value;
                                        }
                                        ?>
                                        <td>{{ float($cons).' '.($device['fuel_measurement_id'] == 1 ? trans('front.liters') : trans('front.gallons')) }}</td>
                                    @endif
                                </tr>
                                <tr>
                                    <td><strong>{{ rtl(trans('front.route_end'), $data) }}:</strong></td>
                                    <td>{{ $items[$device['id']]->route_end }}</td>
                                    <td><strong>{{ rtl(trans('front.fuel_cost'), $data) }}:</strong></td>
                                    <td>
                                        @if (empty($items[$device['id']]->fuel_consumption))
                                            <?php $fuel_consumption = $device['fuel_measurement_id'] == 1 ? $items[$device['id']]->distance_sum * $device['fuel_per_km'] : litersToGallons($items[$device['id']]->distance_sum * $device['fuel_per_km']); ?>
                                            {{ float($fuel_consumption * $device['fuel_price']) }}
                                        @else
                                            <?php $value = array_sum($items[$device['id']]->fuel_consumption); ?>
                                            {{ float($value * $device['fuel_price']) }}
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>{{ rtl(trans('front.route_length'), $data) }}</strong></td>
                                    <td>{{ $items[$device['id']]->unit_of_distance == 'mi' ? kilometersToMiles($items[$device['id']]->distance_sum) : $items[$device['id']]->distance_sum }} {{ trans('front.'.$items[$device['id']]->unit_of_distance) }}</td>
                                    <th>{{ rtl(trans('front.engine_work'), $data) }}:</th>
                                    <td>{{ $items[$device['id']]->engine_work }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ rtl(trans('front.move_duration'), $data) }}:</strong></td>
                                    <td>{{ $items[$device['id']]->move_duration }}</td>
                                    <th>{{ rtl(trans('front.engine_idle'), $data) }}:</th>
                                    <td>{{ $items[$device['id']]->engine_idle }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ rtl(trans('front.stop_duration'), $data) }}:</strong></td>
                                    <td>{{ $items[$device['id']]->stop_duration }}</td>
                                    <th>{{ rtl(trans('front.odometer'), $data) }}:</th>
                                    <td>{{ $items[$device['id']]->odometer }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ rtl(trans('front.stop_count'), $data) }}:</strong></td>
                                    <td>{{ $items[$device['id']]->stop_count }}</td>
                                    <th>{{ rtl(trans('validation.attributes.engine_hours'), $data) }}:</th>
                                    <td>{{ $items[$device['id']]->engine_hours }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ rtl(trans('front.top_speed'), $data) }}:</strong></td>
                                    <td>{{ $items[$device['id']]->top_speed }} {{ trans("front.dis_h_{$items[$device['id']]->unit_of_distance}") }}</td>
                                    <th>{{ rtl(trans('front.drivers'), $data) }}:</th>
                                    <td>{{ $items[$device['id']]->getDrivers() }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ rtl(trans('front.average_speed'), $data) }}:</strong></td>
                                    <td>{{ $items[$device['id']]->average_speed }} {{ trans("front.dis_h_{$items[$device['id']]->unit_of_distance}") }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ rtl(trans('front.overspeed_count'), $data) }}:</strong></td>
                                    <td>{{ $items[$device['id']]->overspeed_count }}</td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    @endforeach
@stop

