@extends('Frontend.Reports.parse.layout')

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">
            {{ rtl(trans('front.report_type'), $data) }}: {{ rtl($types[$data['type']], $data) }}
        </div>
        <div class="panel-body">
            <table class="table" style="margin-bottom: 0px">
                <tbody>
                <tr>
                    <th>{!! rtl(trans('front.time_period'), $data) !!}:</th>
                    <td>{{ $data['date_from'] }} - {{ $data['date_to'] }}</td>
                    <th>&nbsp;</th>
                    <td>&nbsp;</td>
                </tr>
                </tbody>
            </table>
        </div>
        <div class="panel-body no-padding">
            <table class="table table-striped table-speed" style="margin-bottom: 0px">
                <thead>
                <tr>
                    <th>{{ rtl(trans('validation.attributes.device_id'), $data) }}</th>
                    <th>{{ rtl(trans('front.route_start'), $data) }}</th>
                    <th>{{ rtl(trans('front.route_end'), $data) }}</th>
                    <th>{{ rtl(trans('front.route_length'), $data) }}</th>
                    <th>{{ rtl(trans('front.move_duration'), $data) }}</th>
                    <th>{{ rtl(trans('front.stop_duration'), $data) }}</th>
                    <th>{{ rtl(trans('front.stop_count'), $data) }}</th>
                    <th>{{ rtl(trans('front.top_speed'), $data) }}</th>
                    <th>{{ rtl(trans('front.average_speed'), $data) }}</th>
                    <th>{{ rtl(trans('front.overspeed_count'), $data) }}</th>
                    <th>{{ rtl(trans('front.odometer'), $data) }}</th>
                </tr>
                </thead>
                <tbody>
                <?php
                $total_route_length = 0;
                $total_move_duration = 0;
                $total_stop_duration = 0;
                $total_stop_count = 0;
                $total_overspeed_count = 0;
                $total_odometer = 0;
                ?>
                @foreach ($devices as $device)
                    @if ( ! isset($items[$device['id']]))
                        <tr>
                            <td>{{ rtl($device['name'], $data) }}</td>
                            <td colspan="20">{{ rtl(trans('front.nothing_found_request'), $data) }}</td>
                        </tr>
                    @else
                        <?php
                        $total_route_length += $items[$device['id']]->unit_of_distance == 'mi' ? kilometersToMiles($items[$device['id']]->distance_sum) : $items[$device['id']]->distance_sum;
                        $total_move_duration += $items[$device['id']]->move_duration_seconds;
                        $total_stop_duration += $items[$device['id']]->stop_duration_seconds;
                        $total_stop_count += $items[$device['id']]->stop_count;
                        $total_overspeed_count += $items[$device['id']]->overspeed_count;
                        $total_odometer += $items[$device['id']]->odometer;
                        ?>
                        <tr>
                            <td>{{ rtl($device['name'], $data) }}</td>
                            <td>{{ $items[$device['id']]->route_start }}</td>
                            <td>{{ $items[$device['id']]->route_end }}</td>
                            <td>{{ $items[$device['id']]->unit_of_distance == 'mi' ? kilometersToMiles($items[$device['id']]->distance_sum) : $items[$device['id']]->distance_sum }} {{ trans('front.'.$items[$device['id']]->unit_of_distance) }}</td>
                            <td>{{ $items[$device['id']]->move_duration }}</td>
                            <td>{{ $items[$device['id']]->stop_duration }}</td>
                            <td>{{ $items[$device['id']]->stop_count }}</td>
                            <td>{{ $items[$device['id']]->top_speed }} {{ trans("front.dis_h_{$items[$device['id']]->unit_of_distance}") }}</td>
                            <td>{{ $items[$device['id']]->average_speed }} {{ trans("front.dis_h_{$items[$device['id']]->unit_of_distance}") }}</td>
                            <td>{{ $items[$device['id']]->overspeed_count }}</td>
                            <td>{{ $items[$device['id']]->odometer }}</td>
                        </tr>
                    @endif
                @endforeach
                <tr>
                    <td><b>{{ trans('front.total') }}</b></td>
                    <td></td>
                    <td></td>
                    <td>{{ $total_route_length }} {{ trans('front.'. $data['unit_of_distance']) }}</td>
                    <td>{{ secondsToTime($total_move_duration) }}</td>
                    <td>{{ secondsToTime($total_stop_duration) }}</td>
                    <td>{{ $total_stop_count }}</td>
                    <td></td>
                    <td></td>
                    <td>{{ $total_overspeed_count }}</td>
                    <td>{{ $total_odometer }} {{ trans('front.'. $data['unit_of_distance']) }}</td>
                </tr>
                </tbody>
            </table>
        </div>
    </div>
@stop