@extends('Frontend.Reports.parse.layout')

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">
            {{ rtl(trans('front.report_type'), $data) }}: {{ rtl($types[$data['type']], $data) }}
        </div>
        <div class="panel-body">
            <table class="table" style="margin-bottom: 0px">
                <tbody>
                <tr>
                    <th>{!! rtl(trans('front.time_period'), $data) !!}:</th>
                    <td>{{ $data['date_from'] }} - {{ $data['date_to'] }}</td>
                    <th>&nbsp;</th>
                    <td>&nbsp;</td>
                </tr>
                </tbody>
            </table>
        </div>
        <div class="panel-body no-padding">
            <table class="table table-striped table-speed" style="margin-bottom: 0px">
                <thead>
                <tr>
                    <th>{{ trans('validation.attributes.name') }}</th>
                    <th>{{ trans('front.time') }}</th>
                    <th>{{ trans('front.position') }}</th>
                    <th>{{ trans('front.speed') }}</th>
                    <th>{{ trans('front.altitude') }}</th>
                    <th>{{ trans('front.angle') }}</th>
                    <th>{{ trans('validation.attributes.status') }}</th>
                    <th>{{ trans('front.odometer') }}</th>
                    <th>{{ trans('front.engine_hours') }}</th>
                </tr>
                </thead>
                <tbody>
                @if (empty($devices))
                    <tr>
                        <td colspan="20">{{ rtl(trans('front.nothing_found_request'), $data) }}</td>
                    </tr>
                @else
                    @foreach ($items as $item)
                        @if (is_null($item['time']))
                            <tr>
                                <td>{{ $item['name'] }}</td>
                                <td colspan="20">{{ rtl(trans('front.nothing_found_request'), $data) }}</td>
                            </tr>
                        @else
                        <tr>
                            <td>{{ $item['name'] }}</td>
                            <td>{{ $item['time'] }}</td>
                            <td>
                                @if( ! empty($item['lat']) && ! empty($item['lng']))
                                    <a href="http://maps.google.com/maps?q={{ $item['lat'] }},{{ $item['lng'] }}&t=m" target="_blank">
                                        {{ $item['lat'] }} &deg;, {{ $item['lng'] }} &deg;
                                    </a>
                                @endif
                                @if( ! empty($item['address']))
                                    - {{ rtl($item['address'], $data) }}
                                @endif
                            </td>
                            <td>{{ $item['speed'] }}</td>
                            <td>{{ $item['altitude'] }}</td>
                            <td>{{ $item['course'] }}</td>
                            <td>{{ $item['offline_duration'] }}</td>
                            <td>{{ $item['odometer'] }}</td>
                            <td>{{ $item['engine_hours'] }}</td>
                        </tr>
                        @endif
                    @endforeach
                @endif
                </tbody>
            </table>
        </div>
    </div>
@stop