@extends('Frontend.Reports.parse.layout')

@section('content')
    @foreach ($devices as $device)
        <div class="panel panel-default">
            <div class="panel-heading">
                {{ rtl(trans('front.report_type'), $data) }}: {{ rtl($types[$data['type']], $data) }}
            </div>
            <div class="panel-body">
                <table class="table" style="margin-bottom: 0px">
                    <tbody>
                    <tr>
                        <th>{{ rtl(trans('validation.attributes.device_id'), $data) }}:</th>
                        <th>{{ rtl($device['name'], $data) }}</th>
                        <th>&nbsp;</th>
                        <td>&nbsp;</td>
                    </tr>
                    <tr>
                        <th>{!! rtl(trans('front.time_period'), $data) !!}:</th>
                        <th>{{ $data['date_from'] }} - {{ $data['date_to'] }}</th>
                        <th>&nbsp;</th>
                        <td>&nbsp;</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="panel-body">
                <table class="table" style="margin-bottom: 0px">
                    <tbody>
                    <tr>
                        <th>
                            {{ rtl(trans('front.sensor'), $data) }}
                            {{ (array_key_exists('sensor_name', $data)) ? '"' . $data['sensor_name'] . '"' : lcfirst(trans('global.not_found')) }}
                        </th>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="panel-body no-padding">
                <table class="table table-striped table-speed" style="margin-bottom: 0px">
                    <thead>
                    <tr>
                        <th>{{ rtl(trans('front.loading'), $data) }}</th>
                        <th>{{ rtl(trans('front.unloading'), $data) }}</th>
                        <th>{{ rtl(trans('front.time'), $data) }}</th>
                        <th>{{ rtl(trans('front.last_value'), $data) }}</th>
                        <th>{{ rtl(trans('front.difference'), $data) }}</th>
                        <th>{{ rtl(trans('front.current_value'), $data) }}</th>
                        <th>{{ rtl(trans('front.position'), $data) }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @if (empty($items[$device['id']]))
                        <tr>
                            <td colspan="6">{{ rtl(trans('front.nothing_found_request'), $data) }}</td>
                        </tr>
                    @else
                        @foreach ($items[$device['id']] as $item)
                            <tr>
                                @if($item['state'] === 1)
                                    <td>{{ trans('front.loading') }}</td>
                                    <td></td>
                                @else
                                    <td></td>
                                    <td>{{ trans('front.unloading') }}</td>
                                @endif
                                <td>{{ $item['time'] }}</td>
                                <td>{{ $item['previuos_load'] }}</td>
                                <td>{{ $item['difference'] }}</td>
                                <td>{{ $item['current_load'] }}</td>
                                <td>{{ is_null($item['address']) ? $item['position'] : $item['address'] }}</td>
                            </tr>
                        @endforeach
                    @endif
                    </tbody>
                </table>
            </div>
            @if ( ! empty($items[$device['id']]))
                <div class="panel-body">
                    <table class="table" style="margin-bottom: 0px">
                        <tbody>
                        <tr>
                            <th>{{ rtl(trans('front.total_loading_amount'), $data) }}: {{ rtl($data['loading_count'], $data) }}</th>
                        </tr>
                        <tr>
                            <th>{{ rtl(trans('front.total_unloading_amount'), $data) }}: {{ rtl($data['unloading_count'], $data) }}</th>
                        </tr>
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    @endforeach
@stop