@extends('Frontend.Reports.parse.layout')

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">
            {{ rtl(trans('front.report_type'), $data) }}: {{ rtl($types[$data['type']], $data) }}
        </div>
        <div class="panel-body">
            <table class="table" style="margin-bottom: 0px">
                <tbody>
                <tr>
                    <th>{!! rtl(trans('front.time_period'), $data) !!}:</th>
                    <td>{{ $data['date_from'] }} - {{ $data['date_to'] }}</td>
                    <th>&nbsp;</th>
                    <td>&nbsp;</td>
                </tr>
                </tbody>
            </table>
        </div>
        <div class="panel-body no-padding">
            <table class="table table-striped table-speed" style="margin-bottom: 0px">
                <thead>
                <tr>
                    <th>{{ trans('validation.attributes.installation_date') }}</th>
                    <th>{{ trans('front.object') }} {{ lcfirst(trans('validation.attributes.name')) }}</th>
                    <th>{{ trans('front.device_imei') }}</th>
                    <th>{{ trans('validation.attributes.vin') }}</th>
                    <th>{{ trans('validation.attributes.sim_number') }}</th>
                    <th>{{ trans('validation.attributes.sim_activation_date') }}</th>
                    <th>{{ trans('validation.attributes.sim_expiration_date') }}</th>
                </tr>
                </thead>
                <tbody>
                @if (empty($devices))
                    <tr>
                        <td colspan="7">{{ rtl(trans('front.nothing_found_request'), $data) }}</td>
                    </tr>
                @else
                    @foreach ($devices as $device)
                        <tr>
                            <td>{{ $device['installation_date'] != '0000-00-00' ? $device['installation_date'] : null }}</td>
                            <td>{{ $device['name'] }}</td>
                            <td>{{ $device['imei'] }}</td>
                            <td>{{ $device['vin'] }}</td>
                            <td>{{ $device['sim_number'] }}</td>
                            <td>{{ $device['sim_activation_date'] != '0000-00-00' ? $device['sim_activation_date'] : null }}</td>
                            <td>{{ $device['sim_expiration_date'] != '0000-00-00' ? $device['sim_expiration_date'] : null }}</td>
                        </tr>
                    @endforeach
                @endif
                </tbody>
            </table>
        </div>
    </div>
@stop