@extends('Frontend.Reports.parse.layout')

@section('styles')
    <style>
        .bottomline {
            border-bottom: 1px dotted !important;
        }

        .field {
            white-space: nowrap;
            width: 1%;
            font-weight: bold;
        }
    </style>
@stop

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">
            {{ rtl(trans('front.report_type'), $data) }}: {{ rtl($types[$data['type']], $data) }}
        </div>
        <div class="panel-body">
            <table style="margin-bottom: 0;">
                <tr>
                    <td width="50%">
                        <table class="table" style="margin-bottom: 0">
                            <tbody>
                            <tr>
                                <td class="field">{{ trans('front.koc_group') }}:</td>
                                <td class="bottomline"></td>
                            </tr>
                            <tr>
                                <td class="field">{!! rtl(trans('front.time_period'), $data) !!}:</td>
                                <td class="bottomline"><b>From:</b> {{ $data['date_from'] }}
                                    <b>To:</b> {{ $data['date_to'] }}</td>
                            </tr>
                            <tr>
                                <td class="field">{{ trans('front.contract_number') }}:</td>
                                <td class="bottomline"></td>
                            </tr>
                            <tr>
                                <td class="field">{{ trans('front.contract_title') }}:</td>
                                <td class="bottomline"></td>
                            </tr>
                            <tr>
                                <td class="field">{{ trans('front.contractor_name') }}:</td>
                                <td class="bottomline"></td>
                            </tr>
                            <tr>
                                <td class="field">{{ trans('front.controlling_team') }}:</td>
                                <td class="bottomline"></td>
                            </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </table>


        </div>
        <div class="panel-body no-padding">
            <table class="table table-striped table-speed" style="margin-bottom: 0px">
                <thead>
                <tr>
                    <th>#SL</th>
                    <th>{{ trans('global.date') }}</th>
                    <th>{{ trans('validation.attributes.plate_number') }}</th>
                    <th>{{ trans('front.allowed_speed_limit') . '(' . lcfirst(trans('front.' . $data['unit_of_distance'])) . ')' }}</th>
                    <th>{{ trans('front.overspeed_duration_os') }}</th>
                    <th>{{ trans('front.overspeed_distance_os') . '(' . lcfirst(trans('front.' . $data['unit_of_distance'])) . ')' }}</th>
                    <th>{{ trans('front.tamper_signs') }}</th>
                    <th>{{ trans('front.total_violations') }}</th>
                    <th>{{ trans('front.seatbelt_usage') }}</th>
                    <th>{{ trans('front.remark') }}</th>
                </tr>
                </thead>
                <tbody>
                <?php
                $total_distance = 0;
                $total_duration = 0;
                $index = 0;
                ?>
                @foreach ($devices as $device)
                    @if ( ! empty($items[$device['id']]))
                        <?php
                        $total_distance += $items[$device['id']]['distance'];
                        $total_duration += strtotime($items[$device['id']]['duration']) - strtotime('today');
                        $index++;
                        ?>
                        <tr>
                            <td>{{ $index }}</td>
                            <td>{{ $items[$device['id']]['date'] }}</td>
                            <td>{{ $items[$device['id']]['plate_number'] }}</td>
                            <td>{{ $items[$device['id']]['allowed_speed'] }}</td>
                            <td>{{ $items[$device['id']]['duration'] }}</td>
                            <td>{{ $items[$device['id']]['distance'] }}</td>
                            <td>{{ $items[$device['id']]['tamper'] }}</td>
                            <td>{{ $items[$device['id']]['count'] }}</td>
                            <td>{{ $items[$device['id']]['seat_belt'] }}</td>
                            <td>{{ $items[$device['id']]['remarks'] }}</td>
                        </tr>
                    @endif
                @endforeach
                @if ( ! empty($items[$device['id']]))
                    <tr>
                        <td>{{ trans('front.total') }}:</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td>{{ secondsToTime($total_duration) }}</td>
                        <td>{{ $total_distance }}</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                </tbody>
                @endif
            </table>
        </div>
    </div>
@stop