@extends('Frontend.Reports.parse.layout')

@section('styles')
    <style>
        .bottomline {
            border-bottom: 1px dotted !important;
        }

        .field {
            white-space: nowrap;
            width: 1%;
            font-weight: bold;
        }
    </style>
@stop

@section('content')
    @foreach ($devices as $device)
        @if ( ! empty($items[$device['id']]))
            <div class="panel panel-default">
                <div class="panel-heading">
                    {{ rtl(trans('front.report_type'), $data) }}: {{ rtl($types[$data['type']], $data) }}
                </div>
                <div class="panel-body">
                    <table style="margin-bottom: 0;" class="table">
                        <tr>
                            <td width="50%" style="padding-right: 40px;">
                                <table class="table">
                                    <tbody>
                                    <tr>
                                        <td class="field">{{ trans('front.koc_group') }}:</td>
                                        <td class="bottomline"></td>
                                    </tr>
                                    <tr>
                                        <td class="field">{{ trans('front.vehicle_registration_number') }}:</td>
                                        <td class="bottomline">{{ $data['registration_number'] }}</td>
                                    </tr>
                                    <tr>
                                        <td class="field">{{ trans('front.contract_number') }}:</td>
                                        <td class="bottomline"></td>
                                    </tr>
                                    <tr>
                                        <td class="field">{{ trans('front.contract_title') }}:</td>
                                        <td class="bottomline"></td>
                                    </tr>
                                    <tr>
                                        <td class="field">{{ trans('front.contractor_name') }}:</td>
                                        <td class="bottomline"></td>
                                    </tr>
                                    <tr>
                                        <td class="field">{{ trans('front.controlling_team') }}:</td>
                                        <td class="bottomline"></td>
                                    </tr>
                                    <tr>
                                        <td class="field">{{ trans('front.vehicle_pass_expiry_date') }}:</td>
                                        <td class="bottomline"></td>
                                    </tr>
                                    </tbody>
                                </table>
                            </td>
                            <td width="50%">
                                <table class="table" style="padding: 10px">
                                    <tbody>
                                    <tr>
                                        <td class="field">{!! rtl(trans('front.total') . ' ' . trans('front.travel_time'), $data) !!}:</td>
                                        <td class="bottomline">{{ $data['duration'] }}</td>
                                    </tr>
                                    <tr>
                                        <td class="field">{!! rtl(trans('front.total') . ' ' . trans('global.distance'), $data) !!}:</td>
                                        <td class="bottomline">{{ $data['distance'] . ' ' . $data['unit_of_distance'] }}</td>
                                    </tr>
                                    <tr>
                                        <td class="field">{!! rtl(trans('front.number_of_overspeeds'), $data) !!}:</td>
                                        <td class="bottomline">{{ $data['overspeeds_count'] }}</td>
                                    </tr>
                                    <tr>
                                        <td class="field">{!! rtl(trans('front.highest_recorded_speed'), $data) !!}:</td>
                                        <td class="bottomline">{{ $data['max_speed'] . ' ' . $data['unit_of_distance'] . '/h' }}</td>
                                    </tr>
                                    <tr>
                                        <td class="field">{!! rtl(trans('front.speed_perf_percent'), $data) !!}:</td>
                                        <td class="bottomline">{{ ( ! is_null($data['speed_perf'])) ? $data['speed_perf'] . '%' : ''  }}</td>
                                    </tr>
                                    <tr>
                                        <td class="field">{!! rtl(trans('front.time_period'), $data) !!}:</td>
                                        <td class="bottomline">{{ $data['date_from'] }} - {{ $data['date_to'] }}</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="panel-body no-padding">
                    <table class="table table-striped table-speed" style="margin-bottom: 0px">
                        <thead>
                        <tr>
                            <th>#SL</th>
                            <th>{{ trans('global.date') }}</th>
                            <th>{{ trans('validation.attributes.plate_number') }}</th>
                            <th>{{ trans('front.overspeed_location') }}</th>
                            <th>{{ trans('front.recorded_speed') }}</th>
                            <th>{{ trans('front.heading_direction') }}</th>
                            <th>{{ trans('front.allowed_speed_limit') . '(' . lcfirst(trans('front.' . $data['unit_of_distance'])) . '/h)' }}</th>
                            <th>{{ trans('front.start_time') }}</th>
                            <th>{{ trans('front.end_time') }}</th>
                            <th>{{ trans('front.overspeed_duration_os') }}</th>
                            <th>{{ trans('front.overspeed_distance_os') . '(' . lcfirst(trans('front.' . $data['unit_of_distance'])) . ')' }}</th>
                            <th>{{ trans('front.tamper_signs') }}</th>
                            <th>{{ trans('front.seatbelt_usage') }}</th>
                            <th>{{ trans('front.remark') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($items[$device['id']] as $index => $item)
                            <tr>
                                <td>{{ $index }}</td>
                                <td>{{ $item['date'] }}</td>
                                <td>{{ $item['plate_number'] }}</td>
                                <td>{{ is_null($item['address']) ? $item['lat'] . ', ' . $item['lng'] : $item['address'] }}</td>
                                <td>{{ $item['speed'] }}</td>
                                <td>{{ $item['course'] }}</td>
                                <td>{{ $item['allowed_speed'] }}</td>
                                <td>{{ $item['start_time'] }}</td>
                                <td>{{ $item['end_time'] }}</td>
                                <td>{{ $item['duration'] }}</td>
                                <td>{{ $item['distance'] }}</td>
                                <td>{{ $item['tamper'] }}</td>
                                <td>{{ $item['seat_belt'] }}</td>
                                <td>{{ $item['remarks'] }}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @endif
    @endforeach
@stop