@extends('Frontend.Reports.parse.layout')

@section('content')
    @foreach ($devices as $device)
        <div class="panel panel-default">
            <div class="panel-heading">
                {{ rtl(trans('front.report_type'), $data) }}: {{ rtl($types[$data['type']], $data) }}
            </div>
            <div class="panel-body">
                <table class="table" style="margin-bottom: 0px">
                    <tbody>
                    <tr>
                        <td><strong>{{ rtl(trans('validation.attributes.device_id'), $data) }}:</strong></td>
                        <td>{{ rtl($device['name'], $data) }}</td>
                        <th>&nbsp;</th>
                        <td>&nbsp;</td>
                    </tr>
                    <tr>
                        <th>{!! rtl(trans('front.time_period'), $data) !!}:</th>
                        <td>{{ $data['date_from'] }} - {{ $data['date_to'] }}</td>
                        <th>&nbsp;</th>
                        <td>&nbsp;</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="panel-body no-padding">
                <table class="table table-striped table-speed" style="margin-bottom: 0px">
                    <thead>
                    <tr>
                        <th>{{ rtl(trans('front.time'), $data) }}</th>
                        <th>{{ rtl(trans('front.device_imei'), $data) }}</th>
                        @if($data['admin_or_manager'])
                            <th>{{ rtl(trans('global.user'), $data) }}</th>
                        @endif
                        <th>{{ rtl(trans('front.connection'), $data) }}</th>
                        <th>{{ rtl(trans('front.command'), $data) }}</th>
                        <th>{{ rtl(trans('validation.attributes.status'), $data) }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @if (empty($items[$device['id']]))
                        <tr>
                            <td colspan="6">{{ rtl(trans('front.nothing_found_request'), $data) }}</td>
                        </tr>
                    @else
                        @foreach ($items[$device['id']] as $item)
                            <tr>
                                <td>{{ $item['time'] }}</td>
                                <td>{{ $item['imei'] }}</td>
                                @if($data['admin_or_manager'])
                                    <td>{{ $item['email'] }}</td>
                                @endif
                                <td>{{ $item['connection'] }}</td>
                                <td>{{ $item['command'] }}</td>
                                <td>{{ $item['status'] }}</td>
                            </tr>
                        @endforeach
                    @endif
                    </tbody>
                </table>
            </div>
        </div>
    @endforeach
@stop