@extends('Frontend.Reports.parse.layout')

@section('content')
    @foreach ($devices as $device)
        <div class="panel panel-default">
            <div class="panel-heading">
                {{ rtl(trans('front.report_type'), $data) }}: {{ rtl($types[$data['type']], $data) }}
            </div>
            <div class="panel-body">
                <table class="table" style="margin-bottom: 0px">
                    <tbody>
                    <tr>
                        <td><strong>{{ rtl(trans('validation.attributes.device_id'), $data) }}:</strong></td>
                        <td>{{ rtl($device['name'], $data) }}</td>
                        <th>&nbsp;</th>
                        <td>&nbsp;</td>
                    </tr>
                    <tr>
                        <th>{!! rtl(trans('front.time_period'), $data) !!}:</th>
                        <td>{{ $data['date_from'] }} - {{ $data['date_to'] }}</td>
                        <th>&nbsp;</th>
                        <td>&nbsp;</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="panel-body no-padding">
                <table class="table table-striped table-speed" style="margin-bottom: 0px">
                    <thead>
                    <tr>
                        <th>{{ rtl(trans('front.zone_out'), $data) }}</th>
                        <th>{{ rtl(trans('front.area_starting'), $data) }}</th>
                        <th>{{ rtl(trans('front.zone_in'), $data) }}</th>
                        <th>{{ rtl(trans('front.area_arrival'), $data) }}</th>
                        <th>{{ rtl(trans('front.duration'), $data) }}</th>
                        <th>{{ rtl(trans('global.distance'), $data) }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @if (empty($items[$device['id']]))
                        <tr>
                            <td colspan="20">{{ rtl(trans('front.nothing_found_request'), $data) }}</td>
                        </tr>
                    @else
                        <?php
                        $item_total_distance = 0;
                        current($items[$device['id']]);
                        $last_date = current($items[$device['id']])['date'];
                        ?>
                        @foreach ($items[$device['id']] as $item)
                            <?php $item_total_distance += $item['distance']; ?>
                            @if($last_date != $item['date'])
                                <tr>
                                    <td><strong>{{ $last_date = $item['date'] }}</strong></td>
                                    <td colspan="5"></td>
                                </tr>
                            @endif

                            <tr>
                                <td>{{ $item['left']['time'] }}</td>
                                <td>{{ rtl($item['left']['name'], $data) }}</td>
                                <td>{{ $item['enter']['time'] }}</td>
                                <td>{{ rtl($item['enter']['name'], $data) }}</td>
                                <td>{{ $item['duration'] }}</td>
                                <td>
                                    @if($data['unit_of_distance'] == 'mi')
                                        {{ kilometersToMiles(round($item['distance'], 2)) }}
                                    @else
                                        {{ round($item['distance'], 2) }}
                                    @endif
                                    {{ rtl(trans("front.{$data['unit_of_distance']}"), $data) }}
                                </td>
                            </tr>
                        @endforeach
                        <tr>
                            <td><b>Total:</b></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td>
                                @if($data['unit_of_distance'] == 'mi')
                                    {{ kilometersToMiles(round($item_total_distance, 2)) }}
                                @else
                                    {{ round($item_total_distance, 2) }}
                                @endif
                                {{ rtl(trans("front.{$data['unit_of_distance']}"), $data) }}
                            </td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>
        </div>
    @endforeach
@stop