@extends('Frontend.Reports.parse.layout')

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">
            <table class="table">
                <tr>
                    <th>
                        {{ rtl(trans('front.report_type'), $data) }}: {{ rtl($types[$data['type']], $data) }}
                    </th>
                    <th>{{ $data['date_from'] }} - {{ $data['date_to'] }}</th>
                </tr>
            </table>
        </div>
        <div class="panel-body no-padding">
            <table class="table table-striped table-speed" style="margin-bottom: 0px">
                <thead>
                <tr>
                    <th>{{ rtl(trans('global.device'), $data) }}</th>
                    <th>{{ rtl(trans('global.device'), $data) }} ID</th>
                    <th>{{ rtl(trans('validation.attributes.imei'), $data) }}</th>
                    <th>{{ rtl(trans('front.time'), $data) }}</th>
                    <th>{{ rtl(trans('front.latitude'), $data) }}</th>
                    <th>{{ rtl(trans('front.longitude'), $data) }}</th>
                    <th>{{ rtl(trans('front.address'), $data) }}</th>
                    <th>{{ rtl(trans('front.altitude'), $data) }}</th>
                    <th>{{ rtl(trans('front.speed'), $data) }}</th>
                    @foreach($data['parameters'] as $parameter)
                        <th>{{ rtl($parameter, $data) }}</th>
                    @endforeach
                </tr>
                </thead>

                <tbody>
                    @foreach ($items as $item)
                        @foreach ($item['positions'] as $position)
                        <tr>
                            <td>{!!$item['device']['name']!!}</td>
                            <td>{!!$item['device']['id']!!}</td>
                            <td>{!!$item['device']['imei']!!}</td>
                            <td>{!!$position['time']!!}</td>
                            <td>{!!$position['latitude']!!}</td>
                            <td>{!!$position['longitude']!!}</td>
                            <td>{!!$position['address']!!}</td>
                            <td>{!!$position['altitude']!!}</td>
                            <td>{!!$position['speed']!!}</td>
                            @foreach($data['parameters'] as $parameter)
                                <td>@if (isset($position['other'][$parameter])) {{ $position['other'][$parameter] }} @endif</td>
                            @endforeach
                        </tr>
                        @endforeach
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@stop