<!DOCTYPE html>
<html lang="{{ Language::iso() }}">
<head>
    @include('Frontend.Layouts.partials.head')
    @yield('styles')
</head>
<body>

<div id="header">
    <nav class="navbar navbar-main">
        <div class="container-fluid">
            <div class="navbar-header">
                @if ( has_asset_logo('logo') )
                    <a class="navbar-brand" href="/" title="{{ settings('main_settings.server_name') }}"><img src="{{ asset_logo('logo') }}"></a>
                @endif
            </div>

            <ul class="nav navbar-nav navbar-right">

                @yield('header-menu-items')

                <li class="language-selection">
                    <a href="javascript:" data-url="{{ route('subscriptions.languages') }}" data-modal="language-selection">
                        <img src="{{ Language::flag() }}" alt="Language" class="img-thumbnail">
                    </a>
                </li>
            </ul>

        </div>
    </nav>
</div>

<div class="content">
    <div class="container-fluid">
        @yield('content')
    </div>
</div>

@include('Frontend.Layouts.partials.trans')

@yield('self-scripts')

<script src="{{ asset_resource('assets/js/core.js') }}" type="text/javascript"></script>
<script src="{{ asset_resource('assets/js/app.js') }}" type="text/javascript"></script>
@if (file_exists(storage_path('custom/js.js')))
    <script src="{{ asset_resource('assets/js/custom.js', storage_path('custom/js.js')) }}" type="text/javascript"></script>
@endif

@yield('scripts')

</body>
</html>