@if (!empty($events))
    @foreach ($events as $item)
        <tr data-event-id="{!!$item->id!!}" onClick="app.events.select({!!$item->id!!});">
            <td class="datetime">
                <span class="time">{!! \Carbon\Carbon::parse($item->time)->format(settings('main_settings.default_time_format')) !!}</span>
                <span class="date">{!! \Carbon\Carbon::parse($item->time)->format(settings('main_settings.default_date_format')) !!}</span>
            </td>
            <td>{{ (isset($item->device_name) ? $item->device_name : '') }}</td>
            <td>{!! $item->message !!}</td>
            <td>
                <div class="btn-group dropleft droparrow"  data-position="fixed">
                    <i class="btn icon options" data-toggle="dropdown" data-position="fixed" aria-haspopup="true" aria-expanded="false"></i>
                    <ul class="dropdown-menu">
                        <li>
                            <a href="javascript:;" data-url="{{ route('alerts.edit', $item->alert_id) }}" data-modal="alerts_edit">
                                <span class="icon event"></span>
                                <span class="text">{{ trans('global.alert') }}</span>
                            </a>
                        </li>

                        <li>
                            <a href="javascript:;" data-url="{{ route('events.do_destroy', ['id' => $item->id]) }}" data-modal="events_do_destroy">
                                <span class="icon delete"></span>
                                <span class="text">{{ trans('global.delete') }}</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </td>
            <?php
                $arr = $item->toArray();
                unset($arr['geofence'], $arr['device']);
                if (isset($item->device_name) ?  : '')
                    $arr['device']['name'] = $item->device->name;
                if (isset($item->geofence->name) ?  : '')
                    $arr['geofence']['name'] = $item->geofence->name;
            ?>
            <script>app.events.add({!! json_encode($arr) !!});</script>
        </tr>
    @endforeach
    @if (method_exists($events, 'nextPageUrl') && $events->nextPageUrl())
        <tr>
            <td colspan="4" data-next="{!! $events->nextPageUrl() !!}"></td>
        </tr>
    @endif
@else
    <tr>
        <td class="no-data">{!!trans('front.no_events')!!}</td>
    </tr>
@endif
