@extends('Frontend.Layouts.modal')

@section('title')
    <i class="icon money text-primary"></i> {{ trans('front.expenses') }}
@stop

@section('body')
    <div class="action-block">
        <a href="javascript:"
           class="btn btn-action"
           data-url="{!! route('device_expenses.create') !!}"
           data-modal="expenses_create"
           type="button">
            <i class="icon add"></i> {{ trans('global.add') }} {{ lcfirst(trans('front.expenses')) }}
        </a>
    </div>

    <div id="devices_expenses_table">
        <div data-table>
            @include('Frontend.DeviceExpenses.index_table')
        </div>
    </div>

    @if (count($expenses))
        <div class="nav-pagination">
            {!! $expenses->setPath(route('device_expenses.index'))->render() !!}
        </div>
    @endif

    <script>
        tables.set_config('devices_expenses_table', {
            url: '{!! route('device_expenses.index_table') !!}'
        });

        function expenses_create_modal_callback() {
            tables.get('devices_expenses_table');
        }

        function expenses_edit_modal_callback() {
            tables.get('devices_expenses_table');
        }
    </script>
@stop

@section('buttons')
    <button type="button" class="btn btn-default" data-dismiss="modal">{!!trans('global.cancel')!!}</button>
@stop

