<div class="row">
    @foreach($statuses as $status)
        <div class="col-xs-6 col-sm-4 col-md-2">
            <div class="stat-box" style="background-color: {{ $status['color'] }}">
                <div class="title">{{ $status['label'] }}</div>
                <div class="count">{{ $status['data'] }}</div>
                <div class="link">
                    <a href="{{ $status['url'] }}" data-url="{{ $status['url'] }}" data-modal="device-lookup">{{ trans('global.view_details') }}</a>
                </div>
            </div>
        </div>
    @endforeach
</div>
<div class="row">
    <div class="col-sm-6">
        @include("Frontend.Dashboard.Blocks.device_overview.events")
    </div>
    <div class="col-sm-6">
        <div id="device-statuses-graph" style="width: 100%; height: 200px"></div>
    </div>
</div>

<script type='text/javascript'>
    $(document).ready(function () {
        $.plot('#device-statuses-graph',
            {!! json_encode($statuses) !!},
            {
                series: {
                    pie: {
                        show: true,
                        label: false,
                        stroke: {
                            color: "#ccc",
                            width: 1
                        }
                    }
                },
                legend: {
                    show: true
                }
            });

        $('#device-statuses-graph').css('width', 'auto');

        $('.link').on('click', function(e){
            e.preventDefault();

            app.dashboard.close();
        });
    });
</script>
