<?php namespace Tobuli\Services\StreetviewProviders;

use Illuminate\Support\Facades\Cache;

class MapillaryStreetview extends StreetviewProvider
{
    const SEARCH_URL = 'https://a.mapillary.com/v3/images?';

    const IMAGE_KEY_PLACEHOLDER = '{KEY_PLACEHOLDER}';
    const GET_URL = 'https://images.mapillary.com/'.self::IMAGE_KEY_PLACEHOLDER.'/thumb-320.jpg';

    public function __construct()
    {
        parent::__construct();

        if (is_null($this->key))
            throw new \Exception('Mapillary streetview API key not found!');
    }

    public function getView($location, $size, $heading)
    {
        $image_key = Cache::get(md5($location));

        if ( ! is_null($image_key))
            return $this->downloadImage($image_key);

        $curl = curl_init(self::SEARCH_URL . http_build_query([
                'client_id' => $this->key,
                'closeto'   => $this->reverseCoordinates($location),
                'radius'    => self::DEFAULT_RADIUS,
            ]));

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);

        $response = curl_exec($curl);

        curl_close($curl);

        $response = json_decode($response, true);

        if (empty($response['features']))
            throw new \Exception('Location not found!');

        $image_key = array_get($response['features'], '0.properties.key');

        Cache::put(md5($location), $image_key, strtotime('7 days', 0));

        return $this->downloadImage($image_key);
    }

    private function downloadImage($image_key)
    {
        return file_get_contents(str_replace(self::IMAGE_KEY_PLACEHOLDER, $image_key, self::GET_URL));
    }

    protected function getDefaultViewPath($size)
    {
        return public_path('assets/images/no-streetview.jpg');
    }
}