<?php

namespace Tobuli\Reports\Reports;

use Tobuli\History\Actions\Distance;
use Tobuli\History\Actions\Drivers;
use Tobuli\History\Actions\DriveStop;
use Tobuli\History\Actions\Duration;
use Tobuli\History\Actions\EngineHours;
use Tobuli\History\Actions\Fuel;
use Tobuli\History\Actions\GroupDrive;
use Tobuli\History\Actions\GroupDriver;
use Tobuli\History\Actions\GroupDriveStop;
use Tobuli\History\Actions\GroupOverspeed;
use Tobuli\History\Actions\Harsh;
use Tobuli\History\Actions\Odometer;
use Tobuli\History\Actions\Overspeed;
use Tobuli\History\Actions\Speed;
use Tobuli\History\Group;
use Tobuli\Reports\DeviceHistoryReport;

class RagReport extends DeviceHistoryReport
{
    const TYPE_ID = 14;

    public function typeID()
    {
        return self::TYPE_ID;
    }

    public function title()
    {
        return trans('front.rag');
    }

    protected function getActionsList()
    {
        return [
            Duration::class,
            Distance::class,
            Speed::class,
            Overspeed::class,
            Harsh::class,
            Drivers::class,

            GroupDriver::class,
        ];
    }

    protected function getTable($data)
    {
        $rows = [];

        foreach ($data['groups']->all() as $group)
        {
            $row = $this->getDataFromGroup($group, [
                'drivers',
            ]);

            $distance = $group->stats()->get('distance')->get();
            $duration = $group->stats()->get('overspeed_duration')->get();
            $ha       = $group->stats()->get('harsh_acceleration_count')->get();
            $hb       = $group->stats()->get('harsh_breaking_count')->get();

            $row['distance'] = round($distance, 2);
            $row['duration'] = $duration;
            $row['ha'] = $ha;
            $row['hb'] = $hb;

            $row['score_overspeed'] = ($duration > 0 && $distance > 0) ? float($duration/10/$distance*100) : 0;
            $row['score_harsh_a']   = ($ha > 0 && $distance > 0) ? float($ha/$distance*100) : 0;
            $row['score_harsh_b']   = ($hb > 0 && $distance > 0) ? float($hb/$distance*100) : 0;
            $row['rag']             = $row['score_overspeed'] + $row['score_harsh_a'] + $row['score_harsh_b'];

            $rows[] = $row;
        }

        return [
            'rows'   => $rows,
            'totals' => [],
        ];
    }

    protected function getTotals(Group $group, array $only = [])
    {
        return parent::getTotals($group, ['overspeed_count']);
    }
}