<?php

namespace Tobuli\Reports\Reports;

use Tobuli\History\Actions\AppendSpeedECM;
use Tobuli\History\Actions\Distance;
use Tobuli\History\Actions\Drivers;
use Tobuli\History\Actions\DriveStop;
use Tobuli\History\Actions\Duration;
use Tobuli\History\Actions\EngineHours;
use Tobuli\History\Actions\Fuel;
use Tobuli\History\Actions\GroupDrive;
use Tobuli\History\Actions\GroupDriveStop;
use Tobuli\History\Actions\GroupOverspeed;
use Tobuli\History\Actions\Odometer;
use Tobuli\History\Actions\Overspeed;
use Tobuli\History\Actions\Speed;
use Tobuli\History\Actions\SpeedGPS;
use Tobuli\History\Actions\Tachometer;
use Tobuli\History\Group;
use Tobuli\Reports\DeviceHistoryReport;

class OverspeedsSpeedECMReport extends DeviceHistoryReport
{
    const TYPE_ID = 52;

    public function typeID()
    {
        return self::TYPE_ID;
    }

    public function title()
    {
        return trans('front.overspeeds_speed_ecm');
    }

    public static function isEnabled()
    {
        return settings('plugins.speed_compare_gps_ecm_report.status');
    }

    protected function getActionsList()
    {
        return [
            AppendSpeedECM::class,
            Duration::class,
            Distance::class,
            Speed::class,
            SpeedGPS::class,
            Tachometer::class,
            Overspeed::class,

            GroupOverspeed::class,
        ];
    }

    protected function getTable($data)
    {
        $rows = [];

        foreach ($data['groups']->all() as $group)
        {
            $rows[] = $this->getDataFromGroup($group, [
                'start_at',
                'end_at',
                'duration',
                'speed_max',
                'speed_avg',
                'speed_gps_max',
                'tachometer',
                'location',
            ]);
        }

        return [
            'rows'   => $rows,
            'totals' => [],
        ];
    }

    protected function getTotals(Group $group, array $only = [])
    {
        return parent::getTotals($group, ['overspeed_count']);
    }

    protected function precheckError($device) {
        if ($device->getSensorByType('speed_ecm'))
            return null;

        return dontExist('front.sensor');
    }
}