<?php

namespace Tobuli\Reports\Reports;

use Tobuli\History\Actions\AppendGeofences;
use Tobuli\History\Actions\BreakGeofenceIn;
use Tobuli\History\Actions\Distance;
use Tobuli\History\Actions\Drivers;
use Tobuli\History\Actions\DriveStop;
use Tobuli\History\Actions\Duration;
use Tobuli\History\Actions\EngineHours;
use Tobuli\History\Actions\Fuel;
use Tobuli\History\Actions\GeofencesIn;
use Tobuli\History\Actions\GroupDrive;
use Tobuli\History\Actions\GroupDriveStop;
use Tobuli\History\Actions\GroupOverspeed;
use Tobuli\History\Actions\Odometer;
use Tobuli\History\Actions\Overspeed;
use Tobuli\History\Actions\Speed;
use Tobuli\History\Group;
use Tobuli\Reports\DeviceHistoryReport;

class OverspeedsInGeofenceReport extends DeviceHistoryReport
{
    const TYPE_ID = 47;

    public function typeID()
    {
        return self::TYPE_ID;
    }

    public function title()
    {
        return  trans('front.overspeeds') . ' / ' . trans('front.geofences');
    }

    protected function getActionsList()
    {
        return [
            //Dirty fix sort BreakGeogenceIn before Overspeed stats
            BreakGeofenceIn::class,
            BreakGeofenceIn::class,
            BreakGeofenceIn::class,
            BreakGeofenceIn::class,
            BreakGeofenceIn::class,
            Duration::class,
            Distance::class,
            Speed::class,
            Overspeed::class,
            GeofencesIn::class,

            GroupOverspeed::class,
        ];
    }

    protected function getTable($data)
    {
        $rows = [];

        foreach ($data['groups']->all() as $group)
        {
            $rows[] = $this->getDataFromGroup($group, [
                'start_at',
                'end_at',
                'duration',
                'speed_max',
                'speed_avg',
                'location',
                'geofences_in'
            ]);
        }

        return [
            'rows'   => $rows,
            'totals' => [],
        ];
    }

    protected function getTotals(Group $group, array $only = [])
    {
        return parent::getTotals($group, ['overspeed_count']);
    }
}