<?php

namespace Tobuli\Reports\Reports;

use Tobuli\History\Actions\Distance;
use Tobuli\History\Actions\Drivers;
use Tobuli\History\Actions\DriveStop;
use Tobuli\History\Actions\Duration;
use Tobuli\History\Actions\EngineHours;
use Tobuli\History\Actions\Fuel;
use Tobuli\History\Actions\GroupDailySplit;
use Tobuli\History\Actions\GroupDrive;
use Tobuli\History\Actions\GroupDriveStop;
use Tobuli\History\Actions\GroupGeofenceInOut;
use Tobuli\History\Actions\GroupOverspeed;
use Tobuli\History\Actions\Odometer;
use Tobuli\History\Actions\Overspeed;
use Tobuli\History\Actions\Speed;
use Tobuli\History\Group;
use Tobuli\Reports\DeviceHistoryReport;

class GeofencesInOut24ModeReport extends GeofencesInOutReport
{
    const TYPE_ID = 15;

    public function typeID()
    {
        return self::TYPE_ID;
    }

    public function title()
    {
        return trans('front.geofence_in_out_24_mode');
    }

    protected function getActionsList()
    {
        return [
            Duration::class,
            Distance::class,

            GroupDailySplit::class,
            GroupGeofenceInOut::class,
        ];
    }
}