<?php

namespace Tobuli\Reports\Reports;

use Tobuli\History\Actions\Distance;
use Tobuli\History\Actions\Drivers;
use Tobuli\History\Actions\DriveStop;
use Tobuli\History\Actions\Duration;
use Tobuli\History\Actions\EngineHours;
use Tobuli\History\Actions\Fuel;
use Tobuli\History\Actions\Overspeed;
use Tobuli\History\Actions\Speed;
use Tobuli\History\Group;
use Tobuli\Reports\DeviceHistoryReport;

class GeneralInformationMergedReport extends DeviceHistoryReport
{
    const TYPE_ID = 2;

    public function typeID()
    {
        return self::TYPE_ID;
    }

    public function title()
    {
        return trans('front.general_information_merged');
    }

    protected function getActionsList()
    {
        return [
            DriveStop::class,
            Duration::class,
            Distance::class,
            Speed::class,
            Fuel::class,
            Overspeed::class,
        ];
    }

    protected function generateDevice($device)
    {

        $data = $this->getDeviceHistoryData($device);

        if ($this->isEmptyResult($data))
            return [
                'meta' => $this->getDeviceMeta($device),
                'error' => trans('front.nothing_found_request')
            ];

        return [
            'meta' => $this->getDeviceMeta($device),
            'totals' => $this->getDataFromGroup($data['root'], [
                'start_at',
                'end_at',
                'distance',
                'drive_duration',
                'stop_duration',
                'speed_max',
                'speed_avg',
                'overspeed_count',
                'fuel_consumption',
                'fuel_price',
            ])
        ];
    }
}