<?php

namespace Tobuli\Reports\Reports;

use Formatter;
use Carbon\Carbon;
use Tobuli\Entities\Device;
use Tobuli\Reports\DeviceReport;

class EngineHoursVirtualReport extends DeviceReport
{
    private $result;

    const TYPE_ID = 29;

    public function typeID()
    {
        return self::TYPE_ID;
    }

    public function title()
    {
        return trans('front.engine_hours') . ' ' . trans('validation.attributes.daily');
    }

    protected function generate()
    {
        $this->totals['device_count'] = count($this->devices);
        $this->totals['diff'] = 0;

        foreach ($this->devices as $device)
        {
            $data = $this->generateDevice($device);

            $this->items[] = $data;

            if (empty($data['table']['rows']))
                continue;

            $this->totals['diff'] += array_sum(array_pluck($data['table']['rows'], 'diff'));
        }

        $this->totals['diff'] = round($this->totals['diff'], 2);
    }

    protected function processPosition($position)
    {
        $date = Formatter::time()->date($position->time);

        $value = round($position->getVirtualEngineHours() / 3600, 2);

        if ( ! isset($this->result[$date]['from'])) {
            $this->result[$date]['date'] = $date;
            $this->result[$date]['from'] = $value;
        }

        $this->result[$date]['to'] = $value;
        $this->result[$date]['diff'] = round($this->result[$date]['to'] - $this->result[$date]['from'], 2);
    }

    protected function generateDevice($device)
    {
        $this->result = [];

        $device->positions()->whereBetween('time', [$this->date_from, $this->date_to])
            ->chunk(2000, function($positions) {
                foreach ($positions as $position)
                    $this->processPosition($position);
            });

        if (empty($this->result))
            return [
                'meta' => $this->getDeviceMeta($device),
                'error' => trans('front.nothing_found_request')
            ];


        return [
            'meta' => $this->getDeviceMeta($device),
            'table' => [
                'rows' => $this->result
            ]
        ];
    }
}