<?php

namespace Tobuli\Reports\Reports;

use Tobuli\Reports\DeviceReport;

class ChecklistReport extends DeviceReport
{
    const TYPE_ID = 50;

    public static function isEnabled()
    {
        if ( ! env('SERVICE_CHECKLISTS', false))
            return false;

        $user = getActingUser();

        if ($user->perm('checklist', 'view'))
            return true;

        if ($user->perm('checklist_template', 'view'))
            return true;

        if ($user->perm('checklist_row_management', 'view'))
            return true;

        return false;
    }

    public function typeID()
    {
        return self::TYPE_ID;
    }

    public function title()
    {
        return trans('front.checklist_report');
    }

    protected function generate()
    {
        foreach ($this->devices as $device) {
            $this->items[] = $this->generateDevice($device);
        }
    }

    protected function generateDevice($device)
    {
        $data = [];
        $services = $device
            ->services()
            ->with(['checklists' => function ($q) {
                    if ($this->parameters['status'] == 'complete') {
                        $q->complete();
                    } elseif ($this->parameters['status'] == 'incomplete') {
                        $q->incomplete();
                    }
                },
                'checklists.rows',
            ])
            ->whereHas('checklists', function ($q) {
                if ($this->parameters['status'] == 'complete') {
                    $q->complete();
                } elseif ($this->parameters['status'] == 'incomplete') {
                    $q->incomplete();
                }
            })
            ->get();

        foreach ($services as $service) {
            $data[] = [
                'service' => $service,
                'checklists' => $service->checklists,
            ];
        }

        return [
            'meta' => $this->getDeviceMeta($device),
            'data' => $data,
        ];
    }
}
