<?php

namespace Tobuli\Reports;


use Tobuli\Entities\Geofence;
use Tobuli\Entities\UserDriver;
use Tobuli\History\DeviceHistory;
use Tobuli\History\Group;
use Tobuli\History\StatContainer;

abstract class DeviceSensorDataReport extends DeviceHistoryReport
{
    abstract protected function getSensorTypes();

    protected function getActionsList()
    {
        return [];
    }

    protected function getDeviceHistoryData($device)
    {
        $history = new DeviceHistory($device);

        $history->setConfig([
            'stop_seconds'      => $this->stop_seconds,
            'speed_limit'       => $this->speed_limit,
            'stop_speed'        => $device->min_moving_speed,
            'min_fuel_fillings' => $device->min_fuel_fillings,
            'min_fuel_thefts'   => $device->min_fuel_thefts,
        ]);

        $types = $this->getSensorTypes();
        $sensors = $device->sensors->filter(function($sensor) use ($types) {
            return in_array($sensor->type, $types);
        });

        if ( ! $sensors)
            return null;

        $history->setSensors($sensors);

        $history->registerActions(
            $this->getActionsList()
        );

        $history->setRange($this->date_from, $this->date_to);
        $history->get();

        return $history;
    }

    protected function generateDevice($device)
    {
        $history = $this->getDeviceHistoryData($device);

        if ( ! $history)
            return [
                'meta' => $this->getDeviceMeta($device),
                'error' => trans('front.nothing_found_request')
            ];

        $data = $history->getSensorsData();

        if ( ! $data)
            return [
                'meta' => $this->getDeviceMeta($device),
                'error' => trans('front.nothing_found_request')
            ];

        return [
            'meta'    => $this->getDeviceMeta($device),
            'sensors' => $data,
        ];
    }
}