<?php

namespace Tobuli\Reports;


abstract class DeviceReport extends Report
{
    protected $devices;

    public function setDevices($devices)
    {
        $this->devices = $devices;
    }

    public function getDevices()
    {
        return $this->devices;
    }

    public function getDeviceNames()
    {
        return $this->getDevices()->pluck('name')->all();
    }

    /**
     * @return array
     */
    protected function defaultMetas()
    {
        return [
            'device.name' => trans('validation.attributes.device_id'),
        ];
    }

    protected function getDeviceMeta($device)
    {
        $metas = $this->metas('device');

        if (empty($metas))
            return [];

        $result = [];

        foreach ($metas as $key => $meta)
        {
            $meta['key'] = $key;
            $meta['value'] = $device->{$meta['attribute']};
            $result[$key] = $meta;
        }

        return $result;
    }


    protected function precheckError($device)
    {
        return null;
    }
}