<?php

namespace Tobuli\Importers\Readers;

use Maatwebsite\Excel\Facades\Excel;

abstract class XlsReader extends Reader
{
    public function read($file)
    {
        $rows = [];

        Excel::load($file, function($reader) use (&$rows) {
            $rows = $reader->ignoreEmpty(false)->get()->toArray();
        });

        if (empty($rows)) {
            return null;
        }

        return $rows;
    }

    public function isValidFormat($file)
    {
        $rows = [];
        $headerRow = null;

        try {
            Excel::load($file, function($reader) use (&$rows, &$headerRow) {
                $rows = $reader->ignoreEmpty(false)->get()->toArray();
                $headerRow = $reader->first()->keys()->toArray();
            });
        } catch(\PHPExcel_Reader_Exception $e) {
            return false;
        }

        if (empty($rows)) {
            return false;
        }

        if (!array_filter($headerRow)) {
            return false;
        }

        return true;
    }

    protected function parseRow($row, $headers = [])
    {
        return empty($headers) ? $row : array_combine($headers, $row);
    }
}
