<?php

namespace Tobuli\Importers\Readers;

abstract class CsvReader extends Reader
{
    public function read($file)
    {
        $source = file_get_contents($file);

        $rows = str_getcsv($source, "\n");

        if (empty($rows)) {
            return null;
        }

        $headers = $this->parseRow(array_shift($rows));

        if ( ! is_array($headers) || empty($headers)) {
            return null;
        }

        foreach ($rows as & $row) {
            try {
                $row = $this->parseRow($row, $headers);
            } catch (\Exception $e) {
                continue;
            }
        }

        return $rows;
    }

    protected function parseRow($row, $headers = [])
    {
        $row = str_replace('; ', ';', $row);

        $row = str_getcsv($row, ";");

        return empty($headers) ? $row : array_combine($headers, $row);
    }
}