<?php

namespace Tobuli\Importers\POI\Readers;

use Tobuli\Importers\Readers\CsvReader;

class POICsvReader extends CsvReader
{
    protected function parseRow($row, $headers = [])
    {
        $row = str_replace('; ', ';', $row);

        $row = str_getcsv($row, ";");

        if (empty(last($row))) {
            array_pop($row);
        }

        if (empty($headers)) {
            return $row;
        }

        $row = array_combine($headers, $row);

        $row['coordinates'] = $this->parseCoordinates($row['coordinates']);

        return $row;
    }
}