<?php

namespace Tobuli\Importers;

use Tobuli\Exceptions\ValidationException;

abstract class ImportManager implements ImportMangerInterface
{
    /**
     * @throws \Exception
     */
    public function import($file, $additionals = [])
    {
        $importer = $this->resolve($file);

        $importer->import($file, $additionals);
    }

    /**
     * @throws \Exception
     */
    private function resolve($file)
    {
        // select reader only by file format
        $reader = $this->selectReader($file);

        if (is_null($reader)) {
            throw new ValidationException(['id' => trans('front.unsupported_format')]);
        }

        return app()->make($this->getImporterClass(), [$reader]);
    }

    private function selectReader($file)
    {
        //$format = $this->getGeoFormat($file);
        $format = null;

        $readers = $this->getReadersList();

        if ( ! is_null($format)) {
            $reader_class = array_get($readers, $format);

            return is_null($reader_class) ? null : app()->make($reader_class);
        }

        return $this->forceFindReader($readers, $file);
    }

    private function getGeoFormat($file)
    {
        $content = file_get_contents($file);

        $format = \geoPHP::detectFormat($content);

        if ( ! $format) {
            return null;
        }

        return $format;
    }

    abstract protected function getReadersList();

    private function forceFindReader($readers, $file)
    {
        foreach ($readers as $class) {
            $reader = app()->make($class);

            if ( ! $reader->isValidFormat($file)) {
                continue;
            }

            return $reader;
        }

        return null;
    }

    abstract protected function getImporterClass();
}